#ifndef _IMMTIME_
   #define _IMMTIME_
/*******************************************************************************
* FILE NAME:  immtime.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IMMTime                                                                  *
*     IMMMillisecondTime                                                       *
*     IMMHourMinSecFrameTime                                                   *
*     IMM24FramesPerSecTime                                                    *
*     IMM25FramesPerSecTime                                                    *
*     IMM30FramesPerSecTime                                                    *
*     IMMMinSecFrameTime                                                       *
*     IMMHourMinSecTime                                                        *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ivbase.hpp>

class IString;

#pragma pack(4)


class IMMTime : public IVBase {
typedef IVBase
  Inherited;
public:
/*----------------------------- Constructors ---------------------------------*/
static const unsigned long
  IC_IMPORTM defaultTime;

  IMMTime  ( const IMMTime& time     );
  IMMTime  ( unsigned long  time = defaultTime );
virtual
  ~IMMTime ();

IMMTime
  &operator =  (const IMMTime& time);

/*-------------------------- Diagnostics -------------------------------------*/
virtual Boolean
  isValid        () const;
virtual IString
  asString       () const;

/*-------------------------- Attributes --------------------------------------*/
virtual unsigned long
  hours          () const,
  minutes        () const,
  seconds        () const,
  hundredths     () const,
  thousandths    () const,
  asMMTime       () const;

/*-------------------------- Conversions -------------------------------------*/
virtual operator unsigned long () const;

/*-------------------------- Operators ---------------------------------------*/
IMMTime
  &operator += (const IMMTime& time),
  &operator -= (const IMMTime& time);

IMMTime
  operator +   (const IMMTime& time) const,
  operator -   (const IMMTime& time) const;

Boolean
  operator <   (const IMMTime& time) const,
  operator >   (const IMMTime& time) const,
  operator ==  (const IMMTime& time) const,
  operator !=  (const IMMTime& time) const,
  operator <=  (const IMMTime& time) const,
  operator >=  (const IMMTime& time) const;

/*-------------------------------- Format ------------------------------------*/
enum Format
{
   milliseconds     = 1,
   mmTime,
   minSecFrame      = 5,
   trackMinSecFrame,
   frames           = 8,
   hourMinSec,
   bytes            =11,
   samples,
   hourMinSecFrame,
   mm24FramesPerSecond,
   mm25FramesPerSecond,
   mm30FramesPerSecond,
   mm30FramesPerSecondDrop,
   songpointer                   // JAD 9/26/95 - default WIN32 midi format
};


/*----------------------------- Ordinal --------------------------------------*/
virtual unsigned long
  ordinal             () const;
virtual IMMTime
  &setTimeToOrdinal (unsigned long ordinal);

protected:
/*----------------------------- Implementation -------------------------------*/
IMMTime
  &setMMTime (unsigned long newTime),
  &setValid  (Boolean Valid = true);

private:
/*--------------------------------- Private ----------------------------------*/
unsigned long
  fValue;
Boolean
  fValid;
}; // IMMTime

class IMMMillisecondTime : public IMMTime {
typedef IMMTime
  Inherited;
public:
/*----------------------------- Constructors ---------------------------------*/
  IMMMillisecondTime  ( const IMMMillisecondTime& time );
  IMMMillisecondTime  ( unsigned long time = defaultTime );
  IMMMillisecondTime  ( const IMMTime& time );
virtual
  ~IMMMillisecondTime ();

/*----------------------------- Conversions ----------------------------------*/
virtual operator unsigned long () const;

}; // IMMMillisecondTime


class IMMHourMinSecFrameTime : public IMMTime {
typedef IMMTime
  Inherited;
public:
/*----------------------------- Constructors ---------------------------------*/
  IMMHourMinSecFrameTime  ( const IMMHourMinSecFrameTime& time );
  IMMHourMinSecFrameTime  ( unsigned long value = defaultTime,
                            unsigned long framesPerSecond = 1);
virtual
  ~IMMHourMinSecFrameTime ();

/*-------------------------- Diagnostics -------------------------------------*/
virtual IString
  asString           () const;

/*-------------------------- Conversions -------------------------------------*/
virtual operator unsigned long () const;

/*-------------------------- Attributes --------------------------------------*/
unsigned long
  framesPerSecond    () const;

virtual unsigned long
  frames             () const,
  hours              () const,
  minutes            () const,
  seconds            () const;

/*----------------------------- Ordinal --------------------------------------*/
virtual unsigned long
  ordinal           () const;
virtual IMMTime
  &setTimeToOrdinal (unsigned long ordinal);

private:
/*--------------------------------- Private ----------------------------------*/
unsigned long
  HourMinSecFrameToMM   (unsigned long value, unsigned long fps),
  HourMinSecFrameFromMM (unsigned long value, unsigned long fps);
unsigned long
  fFramesPerSec,
  fOriginal;
};  // IMMHourMinSecFrameTime


class IMM24FramesPerSecondTime : public IMMHourMinSecFrameTime {
typedef IMMHourMinSecFrameTime
  Inherited;
public:
/*----------------------------- Constructors ---------------------------------*/
  IMM24FramesPerSecondTime  ( const IMM24FramesPerSecondTime& time );
  IMM24FramesPerSecondTime  ( unsigned long value = defaultTime );
virtual
  ~IMM24FramesPerSecondTime ();

/*----------------------------- Conversions ----------------------------------*/
virtual operator unsigned long () const;

}; // IMM24FramesPerSecondTime


class IMM25FramesPerSecondTime : public IMMHourMinSecFrameTime {
typedef IMMHourMinSecFrameTime
  Inherited;
public:
/*----------------------------- Constructors ---------------------------------*/
  IMM25FramesPerSecondTime  ( const IMM25FramesPerSecondTime& time );
  IMM25FramesPerSecondTime  ( unsigned long value = defaultTime);
virtual
  ~IMM25FramesPerSecondTime ();

/*----------------------------- Conversions ----------------------------------*/
virtual operator unsigned long () const;

}; // IMM25FramesPerSecondTime


class IMM30FramesPerSecondTime : public IMMHourMinSecFrameTime {
typedef IMMHourMinSecFrameTime
  Inherited;
public:
/*----------------------------- Constructors ---------------------------------*/
  IMM30FramesPerSecondTime  ( const IMM30FramesPerSecondTime& time );
  IMM30FramesPerSecondTime  ( unsigned long value = defaultTime );
virtual
  ~IMM30FramesPerSecondTime ();

/*----------------------------- Conversions ----------------------------------*/
virtual operator unsigned long () const;

}; // IMM30FramesPerSecondTime


typedef IMM30FramesPerSecondTime IMMSMPTE30DropTime;

class IMMMinSecFrameTime : public IMMTime {
typedef IMMTime
  Inherited;
public:
/*----------------------------- Constructors ---------------------------------*/
  IMMMinSecFrameTime  ( const IMMMinSecFrameTime& time );
  IMMMinSecFrameTime  ( unsigned long value = defaultTime);
  IMMMinSecFrameTime  ( const IMMTime& time );
virtual
  ~IMMMinSecFrameTime ();

/*-------------------------- Diagnostics -------------------------------------*/
virtual IString
  asString () const;

/*-------------------------- Conversions -------------------------------------*/
virtual operator unsigned long () const;

/*-------------------------- Attributes --------------------------------------*/
unsigned long
  frames   () const,
  minutes  () const,
  seconds  () const;
}; // IMMMinSecFrameTime


class IMMHourMinSecTime : public IMMTime {
typedef IMMTime
  Inherited;
public:
/*----------------------------- Constructors ---------------------------------*/
  IMMHourMinSecTime  ( const IMMHourMinSecTime& time );
  IMMHourMinSecTime  ( unsigned long value = defaultTime);
  IMMHourMinSecTime  ( const IMMTime& time );
virtual
  ~IMMHourMinSecTime ();

/*-------------------------- Diagnostics -------------------------------------*/
virtual IString
  asString           () const;

/*-------------------------- Attributes --------------------------------------*/
virtual unsigned long
  hours              () const,
  minutes            () const,
  seconds            () const;

/*----------------------------- Ordinal --------------------------------------*/
virtual unsigned long
  ordinal             () const;
virtual IMMTime
  &setTimeToOrdinal (unsigned long ordinal);

/*-------------------------- Conversions -------------------------------------*/
virtual operator unsigned long () const;

}; // IMMHourMinSecTime


#pragma pack()

   #include <immtime.inl>

#endif /* _IMMTIME_ */
