#ifndef _IMMTIME_INL_
   #define _IMMTIME_INL_ 0
/*******************************************************************************
* FILE NAME: immtime.inl                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the definition of the inline functions for the          *
*   classes declared in immtime.hpp                                            *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#ifndef _IMMTIME_
  #undef _IMMTIME_INL_
  #define _IMMTIME_INL_ 1
  #include <immtime.hpp>
#endif

#if _IMMTIME_INL_
  #define inline
#endif

inline unsigned long IMMHourMinSecFrameTime::HourMinSecFrameToMM(unsigned long value, unsigned long fps)
{
  return ((((value) & 0x000000FFL) * 60L * 60L * 3000L) +
          (((value) & 0x0000FF00L) / 0x100L * 60L * 3000L) +
          (((value) & 0x00FF0000L) / 0x10000L * 3000L) +
          (((value) & 0xFF000000L) / 0x1000000L * 3000L/fps));
}

inline unsigned long IMMHourMinSecFrameTime::HourMinSecFrameFromMM(unsigned long value, unsigned long fps)
{
  return ((((value)+63L) >= 0x100UL*60UL*60UL*3000UL) ? 0L :
          (((((((value)+63L) % 3000L)/(3000L/fps))  << 24) & 0xFF000000L) |
           ((((((value)+63L) / 3000L) % 60L) << 16) & 0x00FF0000L)      |
          (((((((value)+63L) / 3000L) / 60L) % 60L) << 8) & 0x0000FF00L) |
           ((((((value)+63L) / 3000L) / 60L) / 60L)  & 0x000000FFL)));
}

#endif // _IMMTIME_INL_
