#ifndef _IMMTTIME_
   #define _IMMTTIME_
/*******************************************************************************
* FILE NAME:  immttime.hpp                                                     *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IMMTrackMinSecFrameTime                                                  *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <immtime.hpp>
#include <istring.hpp>

class IMMAudioCDContents;

#pragma pack(4)


class IMMTrackMinSecFrameTime : public IMMTime {
typedef IMMTime
  Inherited;
public:
/*----------------------------- Constructors ---------------------------------*/
  IMMTrackMinSecFrameTime  ( const IMMTrackMinSecFrameTime& time );
  IMMTrackMinSecFrameTime  ( IMMAudioCDContents& contents,
                             unsigned long value );
  IMMTrackMinSecFrameTime  ( IMMAudioCDContents& contents,
                             unsigned long track,
                             unsigned long minutes,
                             unsigned long seconds,
                             unsigned long frames);
virtual
  ~IMMTrackMinSecFrameTime ();

IMMTrackMinSecFrameTime
  &operator =  (const IMMTrackMinSecFrameTime& time);

/*-------------------------- Conversions -------------------------------------*/
virtual operator unsigned long () const;

/*-------------------------- Operators ---------------------------------------*/
IMMTrackMinSecFrameTime
  &operator += (const IMMTime& time),
  &operator -= (const IMMTime& time);

IMMTrackMinSecFrameTime
  operator +   (const IMMTime& time),
  operator -   (const IMMTime& time);

/*-------------------------- Diagnostics -------------------------------------*/
virtual IString
  asString    () const;

/*-------------------------- Attributes --------------------------------------*/
virtual unsigned long
  frames       () const,
  minutes      () const,
  seconds      () const,
  track        () const;

private:
/*--------------------------------- Private ----------------------------------*/
IMMTime
  fStart,
  fEnd;
unsigned long
  fTrackMinSecFrame;
};  // IMMTrackMinSecFrameTime


#pragma pack()

#endif /* _IMMTTIME_ */
