#ifndef _IMMWAVE_
   #define _IMMWAVE_
/*******************************************************************************
* FILE NAME:  immwav.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IMMWaveAudio                                                             *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <immaud.hpp>
#include <istring.hpp>
#include <immabuf.hpp>

class IMMDeviceSettings;

#pragma pack(4)


class IMMWaveAudio : public IMMConfigurableAudio {
typedef IMMConfigurableAudio
  Inherited;
public:
/*----------------------------- Constructors ---------------------------------*/
  IMMWaveAudio  ( Boolean openNow = true,
                  unsigned long instance = 0,
                  Boolean openShareable = true );

virtual
  ~IMMWaveAudio ();

/*-------------------------------- Buffers -----------------------------------*/

protected:
/*----------------------------- Constructors ---------------------------------*/
  IMMWaveAudio ( unsigned long deviceIdentifier,
                 const IString& newAlias = IString() );

/*-------------------------------- Implementation ----------------------------*/
virtual Boolean
  isOpenStringValid (const IString& deviceName) const;

virtual IMMWaveAudio
  &saveDeviceSettings     (),
  &restoreDeviceSettings  (Boolean newRecordMode = false);

private:
/*--------------------------------- Private ----------------------------------*/

/*--------------------------------- Hidden Functions--------------------------*/
  IMMWaveAudio          ( const IMMWaveAudio& device );
IMMWaveAudio
 &operator=             ( const IMMWaveAudio& device );

IMMDeviceSettings
  *fDeviceSettings ;

}; //IMMWaveAudio


#pragma pack()

#endif /* _IMMWAVE_ */
