#ifndef _IMNDIHDR_
#define _IMNDIHDR_
/*******************************************************************************
* FILE NAME: imndihdr.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IMenuDrawItemHandler                                                     *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ihandler.hpp>
#include <ibitflag.hpp>
#include <imndievt.hpp>
#include <ipoint.hpp>

#pragma pack(4)

class IMenuDrawItemHandler : public IHandler {
typedef IHandler
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IMenuDrawItemHandler ( );
virtual
 ~IMenuDrawItemHandler ( );

protected:
/*---------------------------- Event Dispatching -----------------------------*/
virtual Boolean
  dispatchHandlerEvent ( IEvent& event );

/*------------------------------ Drawing Flags -------------------------------*/
INESTEDBITFLAGCLASSDEF0(DrawFlag, IMenuDrawItemHandler);
static const DrawFlag
  IC_IMPORTU drewChecked,
  IC_IMPORTU drewDisabled,
  IC_IMPORTU drewSelected;

/*----------------------------- Event Processing -----------------------------*/
virtual Boolean
  setSize     ( IMenuDrawItemEvent& event,
                ISize&              newSize ),
  draw        ( IMenuDrawItemEvent& event,
                DrawFlag&           flag ),
  highlight   ( IMenuDrawItemEvent& event ),
  unhighlight ( IMenuDrawItemEvent& event );
}; // IMenuDrawItemHandler

#pragma pack()

#endif /* _IMNDIHDR_ */
