#ifndef _IMNITEM_INL_
#define _IMNITEM_INL_ 0
/*******************************************************************************
* FILE NAME: imnitem.inl                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the definition of the inline functions for the          *
*   classes declared in imnitem.hpp.                                           *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#ifndef _IMNITEM_
  #undef  _IMNITEM_INL_
  #define _IMNITEM_INL_ 1
  #include <imnitem.hpp>
#endif

#include <ireslib.hpp>
#include <istring.hpp>
#if _IMNITEM_INL_
  #define inline
#endif


inline IMenuItem& IMenuItem :: setSelectable(Boolean state)
{
   if (!state)
     afStyle |= unavailable.asUnsignedLong();
   else
     afStyle &= ~unavailable.asUnsignedLong();
   return *this;
}


#ifndef IC_MOTIFWIN_FLAGNOP
inline IMenuItem& IMenuItem :: setNoDismiss(Boolean)
{
   return *this;
}

inline IMenuItem& IMenuItem :: setFramed(Boolean)
{
   return *this;
}
#endif  // IC_MOTIFWIN_FLAGNOP

inline IMenuItem& IMenuItem :: setChecked(Boolean state)
{
   if (state)
     afAttribute |= checked.asUnsignedLong();
   else
     afAttribute &= ~checked.asUnsignedLong();
   return *this;
}

inline IMenuItem& IMenuItem :: setDisabled(Boolean state)
{
   if (state)
     afAttribute |= disabled.asUnsignedLong();
   else
     afAttribute &= ~disabled.asUnsignedLong();
   return *this;
}

inline IMenuItem& IMenuItem :: setHighlighted(Boolean state)
{
   if (state)
     afAttribute |= highlighted.asUnsignedLong();
   else
     afAttribute &= ~highlighted.asUnsignedLong();
   return *this;
}

inline IBase::Boolean IMenuItem :: isSelectable() const
{
   return !(afStyle & unavailable.asUnsignedLong());
}

inline IBase::Boolean IMenuItem :: isDrawItem() const
{
   return ((IBase::Boolean)(afStyle & drawItem.asUnsignedLong()));
}

inline IBase::Boolean IMenuItem :: isSeparator() const
{
   return ((IBase::Boolean)(afStyle & separator.asUnsignedLong()));
}

inline IBase::Boolean IMenuItem :: isText() const
{
   return ((IBase::Boolean)(afExtendedStyle & textItem.asExtendedUnsignedLong()));
}

inline IBase::Boolean IMenuItem :: isBitmap() const
{
   return ((IBase::Boolean)(afStyle & bitmapItem.asUnsignedLong()));
}

inline IBase::Boolean IMenuItem :: isSubmenu() const
{
   return ((IBase::Boolean)(afStyle & submenu.asUnsignedLong()));
}

inline IBase::Boolean IMenuItem :: isNoDismiss() const
{
   return false;
}

inline IBase::Boolean IMenuItem :: isFramed() const
{
   return false;
}

inline IBase::Boolean IMenuItem :: isChecked() const
{
   return ((IBase::Boolean)(afAttribute & checked.asUnsignedLong()));
}

inline IBase::Boolean IMenuItem :: isDisabled() const
{
   return ((IBase::Boolean)(afAttribute & disabled.asUnsignedLong()));
}

inline IBase::Boolean IMenuItem :: isHighlighted() const
{
   return ((IBase::Boolean)(afAttribute & highlighted.asUnsignedLong()));
}

inline IMenuItem&  IMenuItem :: setBitmap(unsigned long bitmapResId)
{
  return(setBitmap(IResourceId(bitmapResId)));
}

inline IMenuItem& IMenuItem::setIndex ( unsigned long index)
{
  iPosition = index;
  return *this;
}

inline unsigned long  IMenuItem::id() const
{
    return itemId;
}

inline unsigned long IMenuItem::index  ( ) const
{
    return iPosition;
}

inline IMenuHandle IMenuItem::submenuHandle( ) const
{
    return hwndSubmenu;
}

inline unsigned long IMenuItem:: style( ) const
{
  return afStyle;
}

inline unsigned long IMenuItem:: extendedStyle( ) const
{
  return afExtendedStyle;
}

inline unsigned long IMenuItem::attribute ( ) const
{
  return afAttribute;
}

inline unsigned long IMenuItem::helpId ( ) const
{
  return afHelpId;
}

inline IString IMenuItem::text( ) const
{
  return strClItemText;
}

inline IBitmapHandle IMenuItem::bitmap ( ) const
{
  return hBitmapHandle;
}

inline IMenuItem& IMenuItem::setStyle( unsigned long newStyle )
{
  afStyle = newStyle;
  return *this;
}

inline IMenuItem& IMenuItem::setExtendedStyle( unsigned long newExtStyle )
{
  afExtendedStyle = newExtStyle;
  return *this;
}

inline IMenuItem& IMenuItem::setAttribute( unsigned long newAttribute )
{
  afAttribute = newAttribute;
  return *this;
}

inline IMenuItem& IMenuItem::setHelpId( unsigned long newHelpTopicId )
{
  afHelpId = newHelpTopicId;
  return *this;
}

#endif // _IMNITEM_INL_
