/*******************************************************************************
* FILE NAME: imodel.hpp                                                        *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IModel                                                                   *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*   Portions or this component are based on work originating from Taligent.    *
*   (C) Copyright Taligent, Inc. 1996 - All rights reserved.                   *
*                                                                              *
*******************************************************************************/
#ifndef _IMODEL_
#define _IMODEL_

#include <ivbase.hpp>
#include <imetatyp.hpp>
#include <istring.hpp>

// forward references
class IComponent;
class IBaseStream;
class INotificationEvent;
class INotifier;            

// classes defined in this module
class IModel;

#pragma pack(4)


/*******************************************************************************
*                                                                              *
*   The IModel family of classes support an interface for the document         *
*   model.                                                                     *
*                                                                              *
*******************************************************************************/

class IModel : public IVBase {
public:

/*----------------------- Initialization/Destruction -------------------------*/

    virtual void            attachTo( IComponent& );
    virtual                 ~IModel();


/*--------------------------- Change notification ----------------------------*/

    virtual void            notifyOfChange( const INotificationEvent& );
    virtual Boolean         hasChanged() const;
    virtual void            setChanged( Boolean changed = true );
    virtual INotifier&      notifier() const;
                            operator INotifier& () const;


/*--------------------------- Streaming operators ----------------------------*/

    virtual IBaseStream&    operator>>=( IBaseStream& ) const;
    virtual IBaseStream&    operator<<=( IBaseStream& );

/*------------------------------ Informational -------------------------------*/

    IComponent&             component() const;

#ifdef IC_LIBRARYUSEONLY
    virtual void            fileRenamed( const IString& );

    TypeExtensionDeclarationsMacro(IModel)
#endif

protected:
/*--------------------------- Construction/Copy ------------------------------*/

                            IModel();
                            IModel( const IModel& );
    
private:
    IModel&                 operator=( const IModel& );
    
    enum Version            { kOriginalVersion };
    IComponent*             fpComponent;
    
};

  #include <imodel.inl>


#pragma pack()


#endif // _IMODEL_
