#ifndef _INBDIEVT_
#define _INBDIEVT_
/*******************************************************************************
* FILE NAME: inbdievt.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     INotebookDrawItemEvent                                                   *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <idievt.hpp>

class IPageHandle;

#pragma pack(4)

class INotebookDrawItemEvent : public IDrawItemEvent {
typedef IDrawItemEvent
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  INotebookDrawItemEvent ( IEvent& event );

virtual
  INotebookDrawItemEvent :: ~INotebookDrawItemEvent ( );

/*----------------------------- Page Information -----------------------------*/
virtual IPageHandle
  page                   ( ) const;

virtual unsigned long
  itemId                 ( ) const;
}; // INotebookDrawItemEvent

#pragma pack()

#endif /* _INBDIEVT_ */
