#ifndef _INOTIFEV_
#define _INOTIFEV_
/*******************************************************************************
* FILE NAME: inotifev.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     INotificationEvent                                                       *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/

#include <ibase.hpp>
#include <inotify.hpp>
#include <ievtdata.hpp>

class INotificationEventData;

#pragma pack(4)

class INotificationEvent : public IBase {
typedef IBase
  Inherited;
public:

/*----------------------------- Constructors ---------------------------------*/
  INotificationEvent  ( const INotificationId&   identifier,
                        INotifier&               notifier,
                        Boolean                  notifierAttrChanged=true,
                        const IEventData&        eventData=IEventData(),
                        const IEventData&        observerData=IEventData() );

  INotificationEvent  ( const INotificationEvent& event );

INotificationEvent
 &operator=           ( const INotificationEvent& event );

 ~INotificationEvent ( );

/*----------------------------- Event Attributes -----------------------------*/
INotificationEvent
 &setNotifierAttrChanged  ( Boolean           notifierAttrchanged=true ),
 &setEventData            ( const IEventData& eventData ),
 &setObserverData         ( const IEventData& observerData );

INotificationId
  notificationId          ( ) const;
INotifier
 &notifier                ( ) const;
Boolean
  hasNotifierAttrChanged  ( ) const;
IEventData
  eventData               ( ) const,
  observerData            ( ) const;

private:
/*--------------------------------- Private ----------------------------------*/
INotificationId
  fEvtId;
INotifier
 *fEvtNotifier;
Boolean
 fAttrChanged;
IEventData
 fEvtData,
 fObsData;
INotificationEventData
 *fExtendedNotificationData;
}; //INotificationEvent

#pragma pack()

/*----------------------------- Inline Functions -----------------------------*/
  #include <inotifev.inl>

#endif /* _INOTIFEV_ */
