#ifndef _IOUTLBOX_
  #define _IOUTLBOX_
/*******************************************************************************
* FILE NAME: ioutlbox.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IOutlineBox                                                              *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <icontrol.hpp>
#include <irect.hpp>

class ISize;
class IWindowHandle;
class IColor;
class IPoint;
class IOutlineBoxData;

#pragma pack(4)

class IOutlineBox : public IControl  {
typedef IControl
  Inherited;
public:
class Style;
/*------------------------------ Constructors --------------------------------*/
  IOutlineBox  ( unsigned long     id,
                 IWindow*          parent,
                 IWindow*          owner,
                 const IRectangle& initial = IRectangle(),
                 const Style&      style = defaultStyle() );

  IOutlineBox  ( unsigned long     id,
                 IWindow*          parent );

  IOutlineBox  ( const IWindowHandle& handle);

virtual
 ~IOutlineBox  ( );

/*---------------------------------- Styles ----------------------------------*/
INESTEDBITFLAGCLASSDEF1(Style, IOutlineBox, IWindow);
                                  // style class definition
static const Style
  IC_IMPORTU classDefaultStyle,
  IC_IMPORTU backgroundFrame,
#ifndef IC_MOTIFPM_FLAGNOP
  IC_IMPORTU border3D,
#endif
  IC_IMPORTU foregroundFrame;

static const Style
  IC_IMPORTU halftoneFrame;

static Style
  defaultStyle      ( );

static void
  setDefaultStyle   ( const Style&    style );

virtual unsigned long
  convertToGUIStyle ( const IBitFlag& style,
                      Boolean         extendedOnly = false ) const;

/*---------------------------- Outline Types ---------------------------------*/
enum OutlineType {
  foreground,
  background,
  halftone };

IOutlineBox
 &setOutlineType(const OutlineType& type);
OutlineType
  outlineType() const;

/*----------------------------- Color Members --------------------------------*/
#ifndef IC_WIN_FLAGNOP
virtual IColor
  foregroundColor     ( ) const;
#endif //IC_WIN_FLAGNOP



/*------------------------------ Canvas Support ------------------------------*/
virtual IRectangle
  visibleRectangle   ( ) const;

private:
/*----------------------------- Hidden Members -------------------------------*/
  IOutlineBox  ( const IOutlineBox& outlineBox );
IOutlineBox
 &operator=    ( const IOutlineBox& outlineBox );

/*--------------------------------- Private ----------------------------------*/
static Style
  currentDefaultStyle;

IOutlineBoxData
 *fOutlineBoxData;

};  // class IOutlineBox

INESTEDBITFLAGCLASSFUNCS(Style, IOutlineBox);
                                  // global style functions

#pragma pack()

#endif  // _IOUTLBOX_
