#ifndef _IPAGEEVT_
#define _IPAGEEVT_
/*******************************************************************************
* FILE NAME: ipageevt.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IPageEvent                                                               *
*     IPageRemoveEvent                                                         *
*     IPageHelpEvent                                                           *
*     IPageSelectEvent                                                         *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ictlevt.hpp>

class IBitmapHandle;
class IHelpWindow;
class INotebook;
class IWindow;
class IPageHandle;

#pragma pack(4)


class IPageEvent : public IControlEvent {
typedef IControlEvent
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IPageEvent ( const IEvent&        event        );
  IPageEvent ( const IControlEvent& controlEvent );
  IPageEvent ( const IPageEvent&    pageEvent );

virtual
  ~IPageEvent ( );

/*------------------------------ Page Information ----------------------------*/
virtual IPageHandle
  pageHandle ( ) const;

virtual INotebook
 *notebook   ( ) const;
}; // IPageEvent


class IPageRemoveEvent : public IPageEvent {
typedef IPageEvent
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IPageRemoveEvent ( const IEvent&        event        );
  IPageRemoveEvent ( const IControlEvent& controlEvent );
  IPageRemoveEvent ( const IPageEvent&    pageEvent    );

virtual
  ~IPageRemoveEvent ( );

/*------------------------------ Page Information ----------------------------*/
IWindow
 *pageWindow ( ) const;

IBitmapHandle
  tabBitmap  ( ) const;

virtual INotebook
 *notebook   ( ) const;

private:
/*----------------------------- Hidden Members -------------------------------*/
virtual IPageHandle
  pageHandle ( ) const;
}; // IPageRemoveEvent


class IPageHelpEvent : public IPageEvent {
typedef IPageEvent
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IPageHelpEvent ( const IEvent&        event        );
  IPageHelpEvent ( const IControlEvent& controlEvent );
  IPageHelpEvent ( const IPageEvent&    pageEvent    );

virtual
  ~IPageHelpEvent ( );

/*------------------------------ Help Information ----------------------------*/
IHelpWindow
 *helpWindow ( ) const;

/*------------------------------ Page Information ----------------------------*/
virtual IPageHandle
  pageHandle ( ) const;

virtual INotebook
 *notebook   ( ) const;
}; // IPageHelpEvent


class IPageSelectEvent : public IPageEvent {
typedef IPageEvent
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IPageSelectEvent ( const IEvent&        event        );
  IPageSelectEvent ( const IControlEvent& controlEvent );
  IPageSelectEvent ( const IPageEvent&    pageEvent    );

virtual
  ~IPageSelectEvent ( );

/*------------------------------ Page Information ----------------------------*/
virtual IPageHandle
  pageHandle                 ( ) const;

virtual INotebook
 *notebook                   ( ) const;

IPageHandle
  previousSelectedPageHandle ( ) const;
}; // IPageSelectEvent

#pragma pack()

#endif /* _IPAGEEVT_ */
