#ifndef _IPAINEVT_
  #define _IPAINEVT_
/*******************************************************************************
* FILE NAME: ipainevt.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IPaintEvent                                                              *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ievent.hpp>
#include <icolor.hpp>
#include <ihandle.hpp>
#include <irect.hpp>

#include <igrafctx.hpp>

class IPoint;

#pragma pack(4)

class IPaintEvent : public IEvent {
typedef IEvent
  Inherited;

public:
/*--------------------------- Constructors -----------------------------------*/
  IPaintEvent ( const IEvent& event );
virtual
 ~IPaintEvent ( );

/*--------------------------------- Painting ---------------------------------*/
IPaintEvent
 &clearBackground ( const IColor&     background =
                                      IGUIColor(IGUIColor::desktopBgnd) ),
 &clearBackground ( const IRectangle& fillRectangle,
                    const IColor&     background =
                                      IGUIColor(IGUIColor::desktopBgnd) ),
 &drawText        ( const char*       text,
                    const IPoint&     atPoint,
                    const IColor&     textColor =
                                      IGUIColor(IGUIColor::windowStaticText) );

virtual IPresSpaceHandle
 presSpaceHandle ( );

IPaintEvent
 &setGraphicContext ( const IPresSpaceHandle& handle,
                      Boolean                 setClipRegion = true );
IPaintEvent
 &setGraphicContext ( const IGraphicContext&  context,
                      Boolean                 setClipRegion = true );

IRectangle
  rect ( ) const;

private:
/*--------------------------------- Private ----------------------------------*/
IPaintEvent
 &initializeGC();

IPresSpaceHandle
  hpsCl;
IRectangle
  rectCl;
Boolean
  setGC;
}; // IPaintEvent

#pragma pack()

/*----------------------------- Inline Functions -----------------------------*/
  #include <ipainevt.inl>

#endif /* _IPAINEVT_ */
