#ifndef _IPOINT_
#define _IPOINT_
/*******************************************************************************
* FILE NAME: ipoint.hpp                                                        *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IPair                                                                    *
*     IPoint                                                                   *
*     ISize                                                                    *
*     IRange                                                                   *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ibase.hpp>

#pragma pack(4)

struct _POINTL;
struct _RECTL;
struct _SIZEL;
struct tagPOINT;
struct tagSIZE;
class  ISize;
class  IWindowHandle;
typedef struct tagSIZE SIZEL;

class IPair : public IBase {
typedef IBase
  Inherited;
public:
/*------------------------------ Related Types -------------------------------*/
typedef long Coord;

/*------------------------------ Constructors --------------------------------*/
  IPair ( );
  IPair ( Coord init );
  IPair ( Coord coord1,
          Coord coord2 );

/*-------------------------------- Accessors ---------------------------------*/
Coord
  coord1 ( )  const,
  coord2 ( )  const;

IPair
 &setCoord1 ( Coord coord1 ),
 &setCoord2 ( Coord coord2 );

/*----------------------------- Minimum and Maximum --------------------------*/
IPair
  minimum ( const IPair& aPair ) const,
  maximum ( const IPair& aPair ) const;

/*--------------------------------- Negation ---------------------------------*/
IPair
  operator - ( ) const;

/*--------------------------- Comparison Operators ---------------------------*/
Boolean
  operator == ( const IPair& aPair ) const,
  operator != ( const IPair& aPair ) const,
  operator <  ( const IPair& aPair ) const,
  operator >  ( const IPair& aPair ) const,
  operator <= ( const IPair& aPair ) const,
  operator >= ( const IPair& aPair ) const;

/*-------------------------- Manipulation Operators --------------------------*/
friend IPair
  operator +  ( const IPair& pair1,  const IPair& pair2       ),
  operator *  ( const IPair& pair1,  const IPair& pair2       ),
  operator *  ( const IPair& pair1,  double       multiplier  ),
  operator -  ( const IPair& pair1,  const IPair& pair2       ),
  operator /  ( const IPair& pair1,  const IPair& pair2       ),
  operator /  ( const IPair& pair1,  double       divisor     ),
  operator %  ( const IPair& pair1,  const IPair& pair2       ),
  operator %  ( const IPair& aPair1, long         divisor     );

IPair
 &operator += ( const IPair& aPair ),
 &operator -= ( const IPair& aPair ),
 &operator *= ( const IPair& aPair ),
 &operator *= ( double multiplier ),
 &operator /= ( const IPair& aPair ),
 &operator /= ( double divisor ),
 &operator %= ( const IPair& aPair ),
 &operator %= ( long  divisor );

/*-------------------------- Manipulation Functions --------------------------*/
IPair
 &scaleBy  ( double xFactor, double yFactor ),
  scaledBy ( double xFactor, double yFactor ) const;

/*------------------------------ Miscellaneous -------------------------------*/
double
  distanceFrom ( const IPair& aPair ) const;

long
  dotProduct ( const IPair& aPair ) const;

IPair
 &transpose ( );

friend IPair
  transpose ( const IPair& aPair );

/*-------------------------------- Conversions -------------------------------*/
IString
  asString ( ) const,
  asDebugInfo ( ) const;

/*-------------------------------- Displaying --------------------------------*/
friend ostream
 &operator << ( ostream&          aStream,
                const IPair&      aRectangle );

private:
/*--------------------------------- Private ----------------------------------*/
Coord
  coordCl1,
  coordCl2;
}; // class IPair

class IPoint : public IPair {
typedef IPair
  Inherited;

public:
/*------------------------------- Constructors -------------------------------*/
  IPoint ( );
  IPoint ( const IPair& pair );
  IPoint ( Coord x, Coord y );
  IPoint ( const struct _POINTL& ptl );
  IPoint ( const struct tagPOINT& ptl );

/*-------------------------------- Accessors ---------------------------------*/
Coord
  x      ( ) const,
  y      ( ) const;

IPoint
 &setX ( Coord X ),
 &setY ( Coord Y );

/*-------------------------------- Conversions -------------------------------*/
struct _POINTL
  asPOINTL ( ) const;
}; // class IPoint

class ISize  : public IPair {
typedef IPair
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  ISize ( );
  ISize ( const IPair& pair );
  ISize ( Coord width, Coord height );
  ISize ( const SIZEL& sizl );
  ISize ( const struct _RECTL& rcl );

/*-------------------------------- Accessors ---------------------------------*/
Coord
  width  ( ) const,
  height ( ) const;

ISize
 &setWidth  ( Coord cx ),
 &setHeight ( Coord cy );

/*-------------------------------- Conversions -------------------------------*/
SIZEL
  asSIZEL ( ) const;
}; // class ISize

class IRange : public IPair {
typedef IPair
  Inherited;

public:
/*------------------------------- Constructors -------------------------------*/
  IRange ( );
  IRange ( const IPair& aPair );
  IRange ( Coord lower, Coord upper );

/*-------------------------------- Accessors ---------------------------------*/
Coord
  lowerBound ( ) const,
  upperBound ( ) const;

IRange
 &setUpperBound ( Coord upper ),
 &setLowerBound ( Coord lower );

/*--------------------------------- Testing ----------------------------------*/
Boolean
  includes ( Coord aValue ) const;
}; // class IRange

#pragma pack()

/*----------------------------- Inline Functions -----------------------------*/
  #include <ipoint.inl>

#endif /* _IPOINT_ */
