/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IPQU_H
#define _IPQU_H

#include <iapqu.h>
#include <iicksb.h>
#include <iivksb.h>
#include <iiksblst.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class Key, class ElementOps>
class IGPriorityQueue;

template <class Element, class Key, class ElementOps>
class IGPriorityQueueCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef  IGPriorityQueue
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGPriorityQueueCursor
                            (IGPriorityQueue
                              <
                               Element, Key, ElementOps> const&);

  IGPriorityQueueCursor <Element, Key, ElementOps>&
           operator=        (IGPriorityQueueCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGPriorityQueueCursor
                            (ICursorImpl*);

private:


};

template <class Element, class Key, class ElementOps>
class IGPriorityQueue :
  public IAPriorityQueue <Element, Key> {
protected:

  typedef  IGPriorityQueue <Element, Key, ElementOps> Self;

  typedef  IKeySortedBagAsListImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICKeySortedBagImpl
            <PureImplementation> Implementation;
#endif

#define IGPriorityQueueTypedef(Element, Key, ElementOps)\
  typedef  IKeySortedBagAsListOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGPriorityQueueTypedef (Element, Key, ElementOps);

public:

  typedef  IGPriorityQueueCursor
            <Element, Key, ElementOps> Cursor;


           IGPriorityQueue
                            (INumber = 100);

           IGPriorityQueue
                            (IGPriorityQueue
                              <
                               Element, Key, ElementOps> const&);

  IGPriorityQueue <Element, Key, ElementOps>&
           operator=        (IGPriorityQueue
                              <
                               Element, Key, ElementOps> const&);


protected:

           IGPriorityQueue
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGPriorityQueue
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGPriorityQueueCursor
            <Element, Key, ElementOps>;



};

template <class Element, class Key>
class IPriorityQueue :
  public IGPriorityQueue
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IGPriorityQueue
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef  IPriorityQueue <Element, Key> Self;

#define IPriorityQueueTypedef(Element, Key)\
  typedef  IKeySortedBagAsListOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IPriorityQueue
                            (INumber = 100);


protected:

           IPriorityQueue
                              (PureImplementation&);

private:


};

template <class Element, class Key, class ElementOps>
class IVGPriorityQueue :
  public IGPriorityQueue
          <Element, Key, ElementOps > {

  typedef  IVGPriorityQueue
            <Element, Key, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVKeySortedBagImpl
            <PureImplementation> Implementation;
#else
  typedef  ICKeySortedBagImpl
            <IVKeySortedBagImpl
              <PureImplementation> > Implementation;
#endif

#define IVGPriorityQueueTypedef(Element, Key, ElementOps)\
  typedef  IKeySortedBagAsListOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGPriorityQueueTypedef (Element, Key, ElementOps);

public:

           IVGPriorityQueue
                            (INumber = 100);


protected:

           IVGPriorityQueue
                              (PureImplementation&);

private:


};

template <class Element, class Key>
class IVPriorityQueue :
  public IVGPriorityQueue
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IVGPriorityQueue
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef  IVPriorityQueue <Element, Key> Self;

#define IVPriorityQueueTypedef(Element, Key)\
  typedef  IVKeySortedBagAsListOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IVPriorityQueue
                            (INumber = 100);


protected:

           IVPriorityQueue
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <ipqu.inl>

#pragma info (restore)
#pragma pack ()

#endif
