/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGPriorityQueueCursor
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGPriorityQueueCursor <Element, Key, ElementOps>::
IGPriorityQueueCursor
  (IGPriorityQueue
    <Element, Key, ElementOps> const& collection)
: IOrderedCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class Key, class ElementOps>
inline IGPriorityQueueCursor <Element, Key, ElementOps>&
IGPriorityQueueCursor <Element, Key, ElementOps>::
operator=
  (IGPriorityQueueCursor
    <Element, Key, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGPriorityQueueCursor <Element, Key, ElementOps>::
IGPriorityQueueCursor (ICursorImpl* impl)
: IOrderedCursor <Element> (impl)
{
}

// ---
// IGPriorityQueue
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGPriorityQueue <Element, Key, ElementOps>::
IGPriorityQueue (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class Key, class ElementOps>
inline
IGPriorityQueue <Element, Key, ElementOps>::
IGPriorityQueue
  (IGPriorityQueue
    <Element, Key, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class Key, class ElementOps>
inline IGPriorityQueue <Element, Key, ElementOps>&
IGPriorityQueue <Element, Key, ElementOps>::
operator= (IGPriorityQueue
            <Element, Key, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGPriorityQueue <Element, Key, ElementOps>::
IGPriorityQueue (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class Key, class ElementOps>
inline IGPriorityQueue
 <Element, Key, ElementOps>::Implementation&
IGPriorityQueue <Element, Key, ElementOps>::
ImplOf (IGPriorityQueue
         <Element, Key, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// IPriorityQueue
// ---

// public members

template <class Element, class Key>
inline
IPriorityQueue <Element, Key>::
IPriorityQueue (INumber numberOfElements)
: IGPriorityQueue
   <Element, Key, IKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IPriorityQueue <Element, Key>::
IPriorityQueue (PureImplementation& impl)
: IGPriorityQueue
   <Element, Key, IKCOps <Element, Key> > (impl)
{
}

// ---
// IVGPriorityQueue
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IVGPriorityQueue <Element, Key, ElementOps>::
IVGPriorityQueue (INumber numberOfElements)
: IGPriorityQueue
    <Element, Key, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IVGPriorityQueue <Element, Key, ElementOps>::
IVGPriorityQueue (PureImplementation& impl)
: IGPriorityQueue
    <Element, Key, ElementOps> (impl)
{
}

// ---
// IVPriorityQueue
// ---

// public members

template <class Element, class Key>
inline
IVPriorityQueue <Element, Key>::
IVPriorityQueue (INumber numberOfElements)
: IVGPriorityQueue
   <Element, Key, IKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IVPriorityQueue <Element, Key>::
IVPriorityQueue (PureImplementation& impl)
: IVGPriorityQueue
   <Element, Key, IKCOps <Element, Key> > (impl)
{
}
