/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IPQUDIL_H
#define _IPQUDIL_H

#include <iapqu.h>
#include <iicksb.h>
#include <iivksb.h>
#include <iiksbdil.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class Key, class ElementOps>
class IGPriorityQueueAsDilTable;

template <class Element, class Key, class ElementOps>
class IGPriorityQueueAsDilTableCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef  IGPriorityQueueAsDilTable
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGPriorityQueueAsDilTableCursor
                            (IGPriorityQueueAsDilTable
                              <
                               Element, Key, ElementOps> const&);

  IGPriorityQueueAsDilTableCursor <Element, Key, ElementOps>&
           operator=        (IGPriorityQueueAsDilTableCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGPriorityQueueAsDilTableCursor
                            (ICursorImpl*);

private:


};

template <class Element, class Key, class ElementOps>
class IGPriorityQueueAsDilTable :
  public IAPriorityQueue <Element, Key> {
protected:

  typedef  IGPriorityQueueAsDilTable <Element, Key, ElementOps> Self;

  typedef  IKeySortedBagAsDilTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICKeySortedBagImpl
            <PureImplementation> Implementation;
#endif

#define IGPriorityQueueAsDilTableTypedef(Element, Key, ElementOps)\
  typedef  IKeySortedBagAsDilTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGPriorityQueueAsDilTableTypedef (Element, Key, ElementOps);

public:

  typedef  IGPriorityQueueAsDilTableCursor
            <Element, Key, ElementOps> Cursor;


           IGPriorityQueueAsDilTable
                            (INumber = 100);

           IGPriorityQueueAsDilTable
                            (IGPriorityQueueAsDilTable
                              <
                               Element, Key, ElementOps> const&);

  IGPriorityQueueAsDilTable <Element, Key, ElementOps>&
           operator=        (IGPriorityQueueAsDilTable
                              <
                               Element, Key, ElementOps> const&);


protected:

           IGPriorityQueueAsDilTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGPriorityQueueAsDilTable
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGPriorityQueueAsDilTableCursor
            <Element, Key, ElementOps>;



};

template <class Element, class Key>
class IPriorityQueueAsDilTable :
  public IGPriorityQueueAsDilTable
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IGPriorityQueueAsDilTable
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef  IPriorityQueueAsDilTable <Element, Key> Self;

#define IPriorityQueueAsDilTableTypedef(Element, Key)\
  typedef  IKeySortedBagAsDilTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IPriorityQueueAsDilTable
                            (INumber = 100);


protected:

           IPriorityQueueAsDilTable
                              (PureImplementation&);

private:


};

template <class Element, class Key, class ElementOps>
class IVGPriorityQueueAsDilTable :
  public IGPriorityQueueAsDilTable
          <Element, Key, ElementOps > {

  typedef  IVGPriorityQueueAsDilTable
            <Element, Key, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVKeySortedBagImpl
            <PureImplementation> Implementation;
#else
  typedef  ICKeySortedBagImpl
            <IVKeySortedBagImpl
              <PureImplementation> > Implementation;
#endif

#define IVGPriorityQueueAsDilTableTypedef(Element, Key, ElementOps)\
  typedef  IKeySortedBagAsDilTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGPriorityQueueAsDilTableTypedef (Element, Key, ElementOps);

public:

           IVGPriorityQueueAsDilTable
                            (INumber = 100);


protected:

           IVGPriorityQueueAsDilTable
                              (PureImplementation&);

private:


};

template <class Element, class Key>
class IVPriorityQueueAsDilTable :
  public IVGPriorityQueueAsDilTable
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IVGPriorityQueueAsDilTable
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef  IVPriorityQueueAsDilTable <Element, Key> Self;

#define IVPriorityQueueAsDilTableTypedef(Element, Key)\
  typedef  IVKeySortedBagAsDilTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IVPriorityQueueAsDilTable
                            (INumber = 100);


protected:

           IVPriorityQueueAsDilTable
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <ipqudil.inl>

#pragma info (restore)
#pragma pack ()

#endif
