/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGPriorityQueueAsDilTableCursor
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGPriorityQueueAsDilTableCursor <Element, Key, ElementOps>::
IGPriorityQueueAsDilTableCursor
  (IGPriorityQueueAsDilTable
    <Element, Key, ElementOps> const& collection)
: IOrderedCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class Key, class ElementOps>
inline IGPriorityQueueAsDilTableCursor <Element, Key, ElementOps>&
IGPriorityQueueAsDilTableCursor <Element, Key, ElementOps>::
operator=
  (IGPriorityQueueAsDilTableCursor
    <Element, Key, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGPriorityQueueAsDilTableCursor <Element, Key, ElementOps>::
IGPriorityQueueAsDilTableCursor (ICursorImpl* impl)
: IOrderedCursor <Element> (impl)
{
}

// ---
// IGPriorityQueueAsDilTable
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGPriorityQueueAsDilTable <Element, Key, ElementOps>::
IGPriorityQueueAsDilTable (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class Key, class ElementOps>
inline
IGPriorityQueueAsDilTable <Element, Key, ElementOps>::
IGPriorityQueueAsDilTable
  (IGPriorityQueueAsDilTable
    <Element, Key, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class Key, class ElementOps>
inline IGPriorityQueueAsDilTable <Element, Key, ElementOps>&
IGPriorityQueueAsDilTable <Element, Key, ElementOps>::
operator= (IGPriorityQueueAsDilTable
            <Element, Key, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGPriorityQueueAsDilTable <Element, Key, ElementOps>::
IGPriorityQueueAsDilTable (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class Key, class ElementOps>
inline IGPriorityQueueAsDilTable
 <Element, Key, ElementOps>::Implementation&
IGPriorityQueueAsDilTable <Element, Key, ElementOps>::
ImplOf (IGPriorityQueueAsDilTable
         <Element, Key, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// IPriorityQueueAsDilTable
// ---

// public members

template <class Element, class Key>
inline
IPriorityQueueAsDilTable <Element, Key>::
IPriorityQueueAsDilTable (INumber numberOfElements)
: IGPriorityQueueAsDilTable
   <Element, Key, IKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IPriorityQueueAsDilTable <Element, Key>::
IPriorityQueueAsDilTable (PureImplementation& impl)
: IGPriorityQueueAsDilTable
   <Element, Key, IKCOps <Element, Key> > (impl)
{
}

// ---
// IVGPriorityQueueAsDilTable
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IVGPriorityQueueAsDilTable <Element, Key, ElementOps>::
IVGPriorityQueueAsDilTable (INumber numberOfElements)
: IGPriorityQueueAsDilTable
    <Element, Key, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IVGPriorityQueueAsDilTable <Element, Key, ElementOps>::
IVGPriorityQueueAsDilTable (PureImplementation& impl)
: IGPriorityQueueAsDilTable
    <Element, Key, ElementOps> (impl)
{
}

// ---
// IVPriorityQueueAsDilTable
// ---

// public members

template <class Element, class Key>
inline
IVPriorityQueueAsDilTable <Element, Key>::
IVPriorityQueueAsDilTable (INumber numberOfElements)
: IVGPriorityQueueAsDilTable
   <Element, Key, IKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IVPriorityQueueAsDilTable <Element, Key>::
IVPriorityQueueAsDilTable (PureImplementation& impl)
: IVGPriorityQueueAsDilTable
   <Element, Key, IKCOps <Element, Key> > (impl)
{
}
