/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IPQULST_H
#define _IPQULST_H

#include <iapqu.h>
#include <iicksb.h>
#include <iivksb.h>
#include <iiksblst.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class Key, class ElementOps>
class IGPriorityQueueAsList;

template <class Element, class Key, class ElementOps>
class IGPriorityQueueAsListCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef  IGPriorityQueueAsList
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGPriorityQueueAsListCursor
                            (IGPriorityQueueAsList
                              <
                               Element, Key, ElementOps> const&);

  IGPriorityQueueAsListCursor <Element, Key, ElementOps>&
           operator=        (IGPriorityQueueAsListCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGPriorityQueueAsListCursor
                            (ICursorImpl*);

private:


};

template <class Element, class Key, class ElementOps>
class IGPriorityQueueAsList :
  public IAPriorityQueue <Element, Key> {
protected:

  typedef  IGPriorityQueueAsList <Element, Key, ElementOps> Self;

  typedef  IKeySortedBagAsListImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICKeySortedBagImpl
            <PureImplementation> Implementation;
#endif

#define IGPriorityQueueAsListTypedef(Element, Key, ElementOps)\
  typedef  IKeySortedBagAsListOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGPriorityQueueAsListTypedef (Element, Key, ElementOps);

public:

  typedef  IGPriorityQueueAsListCursor
            <Element, Key, ElementOps> Cursor;


           IGPriorityQueueAsList
                            (INumber = 100);

           IGPriorityQueueAsList
                            (IGPriorityQueueAsList
                              <
                               Element, Key, ElementOps> const&);

  IGPriorityQueueAsList <Element, Key, ElementOps>&
           operator=        (IGPriorityQueueAsList
                              <
                               Element, Key, ElementOps> const&);


protected:

           IGPriorityQueueAsList
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGPriorityQueueAsList
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGPriorityQueueAsListCursor
            <Element, Key, ElementOps>;



};

template <class Element, class Key>
class IPriorityQueueAsList :
  public IGPriorityQueueAsList
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IGPriorityQueueAsList
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef  IPriorityQueueAsList <Element, Key> Self;

#define IPriorityQueueAsListTypedef(Element, Key)\
  typedef  IKeySortedBagAsListOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IPriorityQueueAsList
                            (INumber = 100);


protected:

           IPriorityQueueAsList
                              (PureImplementation&);

private:


};

template <class Element, class Key, class ElementOps>
class IVGPriorityQueueAsList :
  public IGPriorityQueueAsList
          <Element, Key, ElementOps > {

  typedef  IVGPriorityQueueAsList
            <Element, Key, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVKeySortedBagImpl
            <PureImplementation> Implementation;
#else
  typedef  ICKeySortedBagImpl
            <IVKeySortedBagImpl
              <PureImplementation> > Implementation;
#endif

#define IVGPriorityQueueAsListTypedef(Element, Key, ElementOps)\
  typedef  IKeySortedBagAsListOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGPriorityQueueAsListTypedef (Element, Key, ElementOps);

public:

           IVGPriorityQueueAsList
                            (INumber = 100);


protected:

           IVGPriorityQueueAsList
                              (PureImplementation&);

private:


};

template <class Element, class Key>
class IVPriorityQueueAsList :
  public IVGPriorityQueueAsList
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IVGPriorityQueueAsList
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef  IVPriorityQueueAsList <Element, Key> Self;

#define IVPriorityQueueAsListTypedef(Element, Key)\
  typedef  IVKeySortedBagAsListOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IVPriorityQueueAsList
                            (INumber = 100);


protected:

           IVPriorityQueueAsList
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <ipqulst.inl>

#pragma info (restore)
#pragma pack ()

#endif
