/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IPQUTAB_H
#define _IPQUTAB_H

#include <iapqu.h>
#include <iicksb.h>
#include <iivksb.h>
#include <iiksbtab.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class Key, class ElementOps>
class IGPriorityQueueAsTable;

template <class Element, class Key, class ElementOps>
class IGPriorityQueueAsTableCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef  IGPriorityQueueAsTable
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGPriorityQueueAsTableCursor
                            (IGPriorityQueueAsTable
                              <
                               Element, Key, ElementOps> const&);

  IGPriorityQueueAsTableCursor <Element, Key, ElementOps>&
           operator=        (IGPriorityQueueAsTableCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGPriorityQueueAsTableCursor
                            (ICursorImpl*);

private:


};

template <class Element, class Key, class ElementOps>
class IGPriorityQueueAsTable :
  public IAPriorityQueue <Element, Key> {
protected:

  typedef  IGPriorityQueueAsTable <Element, Key, ElementOps> Self;

  typedef  IKeySortedBagAsTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICKeySortedBagImpl
            <PureImplementation> Implementation;
#endif

#define IGPriorityQueueAsTableTypedef(Element, Key, ElementOps)\
  typedef  IKeySortedBagAsTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGPriorityQueueAsTableTypedef (Element, Key, ElementOps);

public:

  typedef  IGPriorityQueueAsTableCursor
            <Element, Key, ElementOps> Cursor;


           IGPriorityQueueAsTable
                            (INumber = 100);

           IGPriorityQueueAsTable
                            (IGPriorityQueueAsTable
                              <
                               Element, Key, ElementOps> const&);

  IGPriorityQueueAsTable <Element, Key, ElementOps>&
           operator=        (IGPriorityQueueAsTable
                              <
                               Element, Key, ElementOps> const&);


protected:

           IGPriorityQueueAsTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGPriorityQueueAsTable
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGPriorityQueueAsTableCursor
            <Element, Key, ElementOps>;



};

template <class Element, class Key>
class IPriorityQueueAsTable :
  public IGPriorityQueueAsTable
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IGPriorityQueueAsTable
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef  IPriorityQueueAsTable <Element, Key> Self;

#define IPriorityQueueAsTableTypedef(Element, Key)\
  typedef  IKeySortedBagAsTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IPriorityQueueAsTable
                            (INumber = 100);


protected:

           IPriorityQueueAsTable
                              (PureImplementation&);

private:


};

template <class Element, class Key, class ElementOps>
class IVGPriorityQueueAsTable :
  public IGPriorityQueueAsTable
          <Element, Key, ElementOps > {

  typedef  IVGPriorityQueueAsTable
            <Element, Key, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVKeySortedBagImpl
            <PureImplementation> Implementation;
#else
  typedef  ICKeySortedBagImpl
            <IVKeySortedBagImpl
              <PureImplementation> > Implementation;
#endif

#define IVGPriorityQueueAsTableTypedef(Element, Key, ElementOps)\
  typedef  IKeySortedBagAsTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGPriorityQueueAsTableTypedef (Element, Key, ElementOps);

public:

           IVGPriorityQueueAsTable
                            (INumber = 100);


protected:

           IVGPriorityQueueAsTable
                              (PureImplementation&);

private:


};

template <class Element, class Key>
class IVPriorityQueueAsTable :
  public IVGPriorityQueueAsTable
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IVGPriorityQueueAsTable
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef  IVPriorityQueueAsTable <Element, Key> Self;

#define IVPriorityQueueAsTableTypedef(Element, Key)\
  typedef  IVKeySortedBagAsTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IVPriorityQueueAsTable
                            (INumber = 100);


protected:

           IVPriorityQueueAsTable
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <ipqutab.inl>

#pragma info (restore)
#pragma pack ()

#endif
