/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGPriorityQueueAsTableCursor
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGPriorityQueueAsTableCursor <Element, Key, ElementOps>::
IGPriorityQueueAsTableCursor
  (IGPriorityQueueAsTable
    <Element, Key, ElementOps> const& collection)
: IOrderedCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class Key, class ElementOps>
inline IGPriorityQueueAsTableCursor <Element, Key, ElementOps>&
IGPriorityQueueAsTableCursor <Element, Key, ElementOps>::
operator=
  (IGPriorityQueueAsTableCursor
    <Element, Key, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGPriorityQueueAsTableCursor <Element, Key, ElementOps>::
IGPriorityQueueAsTableCursor (ICursorImpl* impl)
: IOrderedCursor <Element> (impl)
{
}

// ---
// IGPriorityQueueAsTable
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGPriorityQueueAsTable <Element, Key, ElementOps>::
IGPriorityQueueAsTable (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class Key, class ElementOps>
inline
IGPriorityQueueAsTable <Element, Key, ElementOps>::
IGPriorityQueueAsTable
  (IGPriorityQueueAsTable
    <Element, Key, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class Key, class ElementOps>
inline IGPriorityQueueAsTable <Element, Key, ElementOps>&
IGPriorityQueueAsTable <Element, Key, ElementOps>::
operator= (IGPriorityQueueAsTable
            <Element, Key, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGPriorityQueueAsTable <Element, Key, ElementOps>::
IGPriorityQueueAsTable (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class Key, class ElementOps>
inline IGPriorityQueueAsTable
 <Element, Key, ElementOps>::Implementation&
IGPriorityQueueAsTable <Element, Key, ElementOps>::
ImplOf (IGPriorityQueueAsTable
         <Element, Key, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// IPriorityQueueAsTable
// ---

// public members

template <class Element, class Key>
inline
IPriorityQueueAsTable <Element, Key>::
IPriorityQueueAsTable (INumber numberOfElements)
: IGPriorityQueueAsTable
   <Element, Key, IKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IPriorityQueueAsTable <Element, Key>::
IPriorityQueueAsTable (PureImplementation& impl)
: IGPriorityQueueAsTable
   <Element, Key, IKCOps <Element, Key> > (impl)
{
}

// ---
// IVGPriorityQueueAsTable
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IVGPriorityQueueAsTable <Element, Key, ElementOps>::
IVGPriorityQueueAsTable (INumber numberOfElements)
: IGPriorityQueueAsTable
    <Element, Key, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IVGPriorityQueueAsTable <Element, Key, ElementOps>::
IVGPriorityQueueAsTable (PureImplementation& impl)
: IGPriorityQueueAsTable
    <Element, Key, ElementOps> (impl)
{
}

// ---
// IVPriorityQueueAsTable
// ---

// public members

template <class Element, class Key>
inline
IVPriorityQueueAsTable <Element, Key>::
IVPriorityQueueAsTable (INumber numberOfElements)
: IVGPriorityQueueAsTable
   <Element, Key, IKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IVPriorityQueueAsTable <Element, Key>::
IVPriorityQueueAsTable (PureImplementation& impl)
: IVGPriorityQueueAsTable
   <Element, Key, IKCOps <Element, Key> > (impl)
{
}
