#ifndef _IPUSHBUT_
  #define _IPUSHBUT_
/*******************************************************************************
* FILE NAME: ipushbut.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IPushButton                                                              *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ibutton.hpp>
#include <irect.hpp>

class ISize;
class IWindowHandle;
class IPushButtonData;

#pragma pack(4)

class IPushButton : public IButton  {
typedef IButton
  Inherited;
public:

class Style;

/*------------------------------- Constructors -------------------------------*/
  IPushButton ( unsigned long id,
                IWindow* parent,
                IWindow* owner,
                const IRectangle& initial= IRectangle(),
                const Style& style = defaultStyle() );

  IPushButton ( unsigned long id,
                IWindow*      parent );

  IPushButton ( const IWindowHandle& handle );

virtual
 ~IPushButton ( );

/*---------------------------------- Styles ----------------------------------*/
INESTEDBITFLAGCLASSDEF3( Style,
                         IPushButton,
                         IWindow,
                         IControl,
                         IButton );

static const Style
  IC_IMPORTU classDefaultStyle,
  IC_IMPORTU help,
  IC_IMPORTU systemCommand,
#ifndef IC_WIN_FLAGNOP
  IC_IMPORTU noBorder,
#endif
  IC_IMPORTU defaultButton;

static Style
  defaultStyle      ( );

static void
  setDefaultStyle   ( const Style&    style );

virtual unsigned long
  convertToGUIStyle ( const IBitFlag& style,
                      Boolean         extendedOnly = false ) const;

/*----------------------------- Style Functions ------------------------------*/
Boolean
  isDefault            ( ) const,
  isHelp               ( ) const,
#ifndef IC_WIN_FLAGNOP
  hasBorder            ( ) const,
#endif
  isSystemCommand      ( ) const;

virtual IPushButton
 &enableDefault        ( Boolean enable = true ),
 &disableDefault       ( ),
 &enableHelp           ( Boolean enable = true ),
 &disableHelp          ( ),
#ifndef IC_WIN_FLAGNOP
 &addBorder            ( Boolean add    = true ),
 &removeBorder         ( ),
#endif
 &enableSystemCommand  ( Boolean enable = true ),
 &disableSystemCommand ( );

protected:

/*-------------------------- Protected Constructors --------------------------*/

/*---------------------------------- Layout ----------------------------------*/
virtual ISize
  calcMinimumSize      ( ) const;

/*---------------------- Event Handling Implementation -----------------------*/

private:
/*--------------------------------- Private ----------------------------------*/
static Style
  currentDefaultStyle;

IPushButtonData
 *fPushButtonData;


/*----------------------------- Hidden Functions -----------------------------*/
  IPushButton          ( const IPushButton& );
IPushButton
 &operator=            ( const IPushButton& );

};  // class IPushButton

INESTEDBITFLAGCLASSFUNCS ( Style, IPushButton );

#pragma pack()

#endif  // _IPUSHBUT_
