/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IQU_H
#define _IQU_H

#include <iaqu.h>
#include <iicseq.h>
#include <iivseq.h>
#include <iiseqlst.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class ElementOps>
class IGQueue;

template <class Element, class ElementOps>
class IGQueueCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef  IGQueue
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGQueueCursor
                            (IGQueue
                              <
                               Element, ElementOps> const&);

  IGQueueCursor <Element, ElementOps>&
           operator=        (IGQueueCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGQueueCursor
                            (ICursorImpl*);

private:


};

template <class Element, class ElementOps>
class IGQueue :
  public IAQueue <Element> {
protected:

  typedef  IGQueue <Element, ElementOps> Self;

  typedef  ISequenceAsListImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSequenceImpl
            <PureImplementation> Implementation;
#endif

#define IGQueueTypedef(Element, ElementOps)\
  typedef  ISequenceAsListOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGQueueTypedef (Element, ElementOps);

public:

  typedef  IGQueueCursor
            <Element, ElementOps> Cursor;


           IGQueue
                            (INumber = 100);

           IGQueue
                            (IGQueue
                              <
                               Element, ElementOps> const&);

  IGQueue <Element, ElementOps>&
           operator=        (IGQueue
                              <
                               Element, ElementOps> const&);


protected:

           IGQueue
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGQueue
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGQueueCursor
            <Element, ElementOps>;



};

template <class Element>
class IQueue :
  public IGQueue
          <Element, IStdOps <Element> > {

  typedef  IGQueue
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef  IQueue <Element> Self;

#define IQueueTypedef(Element)\
  typedef  ISequenceAsListOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

           IQueue
                            (INumber = 100);


protected:

           IQueue
                              (PureImplementation&);

private:


};

template <class Element, class ElementOps>
class IVGQueue :
  public IGQueue
          <Element, ElementOps > {

  typedef  IVGQueue
            <Element, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVSequenceImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSequenceImpl
            <IVSequenceImpl
              <PureImplementation> > Implementation;
#endif

#define IVGQueueTypedef(Element, ElementOps)\
  typedef  ISequenceAsListOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGQueueTypedef (Element, ElementOps);

public:

           IVGQueue
                            (INumber = 100);


protected:

           IVGQueue
                              (PureImplementation&);

private:


};

template <class Element>
class IVQueue :
  public IVGQueue
          <Element, IStdOps <Element> > {

  typedef  IVGQueue
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef  IVQueue <Element> Self;

#define IVQueueTypedef(Element)\
  typedef  IVSequenceAsListOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

           IVQueue
                            (INumber = 100);


protected:

           IVQueue
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <iqu.inl>

#pragma info (restore)
#pragma pack ()

#endif
