/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGQueueCursor
// ---

// public members

template <class Element, class ElementOps>
inline
IGQueueCursor <Element, ElementOps>::
IGQueueCursor
  (IGQueue
    <Element, ElementOps> const& collection)
: IOrderedCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class ElementOps>
inline IGQueueCursor <Element, ElementOps>&
IGQueueCursor <Element, ElementOps>::
operator=
  (IGQueueCursor
    <Element, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGQueueCursor <Element, ElementOps>::
IGQueueCursor (ICursorImpl* impl)
: IOrderedCursor <Element> (impl)
{
}

// ---
// IGQueue
// ---

// public members

template <class Element, class ElementOps>
inline
IGQueue <Element, ElementOps>::
IGQueue (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class ElementOps>
inline
IGQueue <Element, ElementOps>::
IGQueue
  (IGQueue
    <Element, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class ElementOps>
inline IGQueue <Element, ElementOps>&
IGQueue <Element, ElementOps>::
operator= (IGQueue
            <Element, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGQueue <Element, ElementOps>::
IGQueue (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class ElementOps>
inline IGQueue
 <Element, ElementOps>::Implementation&
IGQueue <Element, ElementOps>::
ImplOf (IGQueue
         <Element, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// IQueue
// ---

// public members

template <class Element>
inline
IQueue <Element>::
IQueue (INumber numberOfElements)
: IGQueue
   <Element, IStdOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
IQueue <Element>::
IQueue (PureImplementation& impl)
: IGQueue
   <Element, IStdOps <Element> > (impl)
{
}

// ---
// IVGQueue
// ---

// public members

template <class Element, class ElementOps>
inline
IVGQueue <Element, ElementOps>::
IVGQueue (INumber numberOfElements)
: IGQueue
    <Element, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class ElementOps>
inline
IVGQueue <Element, ElementOps>::
IVGQueue (PureImplementation& impl)
: IGQueue
    <Element, ElementOps> (impl)
{
}

// ---
// IVQueue
// ---

// public members

template <class Element>
inline
IVQueue <Element>::
IVQueue (INumber numberOfElements)
: IVGQueue
   <Element, IStdOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
IVQueue <Element>::
IVQueue (PureImplementation& impl)
: IVGQueue
   <Element, IStdOps <Element> > (impl)
{
}
