/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGQueueAsTableCursor
// ---

// public members

template <class Element, class ElementOps>
inline
IGQueueAsTableCursor <Element, ElementOps>::
IGQueueAsTableCursor
  (IGQueueAsTable
    <Element, ElementOps> const& collection)
: IOrderedCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class ElementOps>
inline IGQueueAsTableCursor <Element, ElementOps>&
IGQueueAsTableCursor <Element, ElementOps>::
operator=
  (IGQueueAsTableCursor
    <Element, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGQueueAsTableCursor <Element, ElementOps>::
IGQueueAsTableCursor (ICursorImpl* impl)
: IOrderedCursor <Element> (impl)
{
}

// ---
// IGQueueAsTable
// ---

// public members

template <class Element, class ElementOps>
inline
IGQueueAsTable <Element, ElementOps>::
IGQueueAsTable (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class ElementOps>
inline
IGQueueAsTable <Element, ElementOps>::
IGQueueAsTable
  (IGQueueAsTable
    <Element, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class ElementOps>
inline IGQueueAsTable <Element, ElementOps>&
IGQueueAsTable <Element, ElementOps>::
operator= (IGQueueAsTable
            <Element, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGQueueAsTable <Element, ElementOps>::
IGQueueAsTable (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class ElementOps>
inline IGQueueAsTable
 <Element, ElementOps>::Implementation&
IGQueueAsTable <Element, ElementOps>::
ImplOf (IGQueueAsTable
         <Element, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// IQueueAsTable
// ---

// public members

template <class Element>
inline
IQueueAsTable <Element>::
IQueueAsTable (INumber numberOfElements)
: IGQueueAsTable
   <Element, IStdOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
IQueueAsTable <Element>::
IQueueAsTable (PureImplementation& impl)
: IGQueueAsTable
   <Element, IStdOps <Element> > (impl)
{
}

// ---
// IVGQueueAsTable
// ---

// public members

template <class Element, class ElementOps>
inline
IVGQueueAsTable <Element, ElementOps>::
IVGQueueAsTable (INumber numberOfElements)
: IGQueueAsTable
    <Element, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class ElementOps>
inline
IVGQueueAsTable <Element, ElementOps>::
IVGQueueAsTable (PureImplementation& impl)
: IGQueueAsTable
    <Element, ElementOps> (impl)
{
}

// ---
// IVQueueAsTable
// ---

// public members

template <class Element>
inline
IVQueueAsTable <Element>::
IVQueueAsTable (INumber numberOfElements)
: IVGQueueAsTable
   <Element, IStdOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
IVQueueAsTable <Element>::
IVQueueAsTable (PureImplementation& impl)
: IVGQueueAsTable
   <Element, IStdOps <Element> > (impl)
{
}
