#ifndef _IRADIOBT_
  #define _IRADIOBT_
/*******************************************************************************
* FILE NAME: iradiobt.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IRadioButton                                                             *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <isetbut.hpp>
#include <irect.hpp>

class ISize;
class IWindowHandle;
class IRadioButtonData;

#pragma pack(4)

class IRadioButton : public ISettingButton  {
typedef ISettingButton
  Inherited;
public:

class Style;

/*------------------------------- Constructors -------------------------------*/
  IRadioButton ( unsigned long id,
                 IWindow* parent,
                 IWindow* owner,
                 const IRectangle& initial= IRectangle(),
                 const Style& style = defaultStyle() );

  IRadioButton ( unsigned long id,
                 IWindow*      parent );

  IRadioButton ( const IWindowHandle& handle );

virtual
 ~IRadioButton ( );

/*---------------------------------- Styles ----------------------------------*/
INESTEDBITFLAGCLASSDEF3( Style,
                         IRadioButton,
                         IWindow,
                         IControl,
                         IButton );

static const Style
  IC_IMPORTU classDefaultStyle,
#ifndef IC_WIN_FLAGNOP
  IC_IMPORTU noCursorSelect,
#endif
  IC_IMPORTU autoSelect;

static Style
  defaultStyle      ( );
static void
  setDefaultStyle   ( const Style&    style);

virtual unsigned long
  convertToGUIStyle ( const IBitFlag& style,
                      Boolean         extendedOnly = false ) const;


/*------------------------------- Auto Select --------------------------------*/
virtual IRadioButton
  &enableAutoSelect    ( Boolean enable=true ),
  &disableAutoSelect   ( );
virtual Boolean
  isAutoSelect         ( ) const;

/*----------------------------- Style Functions ------------------------------*/
#ifndef IC_MOTIFWIN_FLAGNOP
virtual IRadioButton
  &enableCursorSelect  ( Boolean enable=true ),
  &disableCursorSelect ( );
Boolean
  isCursorSelect       ( ) const;
#endif

/*-------------------------------- Selection ---------------------------------*/
static const unsigned long
  IC_IMPORTU noSelections;
unsigned long
  selectedIndex        ( ) const;

protected:
/*---------------------------------- Layout ----------------------------------*/
virtual ISize
  calcMinimumSize      ( ) const;

/*---------------------- Event Handling Implementation -----------------------*/

private:
/*--------------------------------- Private ----------------------------------*/
friend class IRadioHandler;

static Style
  currentDefaultStyle;

IRadioButtonData
 *fRadioButtonData;

/*----------------------------- Hidden Functions -----------------------------*/
  IRadioButton         ( const IRadioButton& );
IRadioButton
 &operator=            ( const IRadioButton& );
};  // class IRadioButton

INESTEDBITFLAGCLASSFUNCS( Style, IRadioButton );

#pragma pack()

#endif  // _IRADIOBT_
