#ifndef _IREFCNT_
#define _IREFCNT_
/*******************************************************************************
* FILE NAME: irefcnt.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IRefCounted                                                              *
*     IReference                                                               *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ivbase.hpp>
#include <iexcept.hpp>

#include <icconst.h>

#pragma pack(4)

class IRefCounted : public IVBase {
typedef IVBase
  Inherited;
public:
/*--------------------------- Reference Counting -----------------------------*/
virtual void
  addRef    ( ),
  removeRef ( );

unsigned
  useCount ( ) const
    {
    return this->refCount;
    }

protected:
/*------------------------------ Constructors --------------------------------*/
  IRefCounted ( );

  ~IRefCounted ( );

private:
/*--------------------------------- Private -----------------------------------*/
unsigned
  refCount;
}; // class IRefCounted

template < class T >
class IReference : public IBase {
public:
/*------------------------------ Constructors --------------------------------*/
  IReference ( T *p = 0 )
    : referent( p )
    {
    }

  IReference ( const IReference<T> &source )
    : referent( source.referent )
    {
    if ( source.referent )
      source.referent -> addRef();
    }

  ~IReference ( )
    {
    if ( referent )
      referent->removeRef();
    }

IReference<T>
 &operator = ( const IReference<T> &source )
  {
  if ( source.referent )
    source.referent -> addRef();
  if ( referent )
    referent -> removeRef();
  referent = source.referent;
  return *this;
  }
IReference<T>
 &operator = ( T *p )
  {
  if ( p )
    p -> addRef();
  if ( referent )
    referent -> removeRef();
  referent = p;
  return *this;
  }

/*-------------------------------- Operators ---------------------------------*/
T
 *operator -> ( ) const
   {
   if ( !referent )
     ITHROWLIBRARYERROR(IC_NULL_IREFERENCE, IBaseErrorInfo::invalidRequest, IException::recoverable);
   return referent;
   }
T
 &operator *  ( ) const
   {
   if ( !referent )
     ITHROWLIBRARYERROR(IC_NULL_IREFERENCE, IBaseErrorInfo::invalidRequest, IException::recoverable);
   return *referent;
   }

 operator T* ( ) const
 {
   return (referent);
 }
private:
/*--------------------------------- Private -----------------------------------*/
T
 *referent;

}; // template class IReference

#pragma pack()

#endif /* _IREFCNT_ */
