/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IRELLST_H
#define _IRELLST_H

#include <iarel.h>
#include <iicrel.h>
#include <iivrel.h>
#include <iirellst.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class Key, class ElementOps>
class IGRelationAsList;

template <class Element, class Key, class ElementOps>
class IGRelationAsListCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef  IGRelationAsList
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGRelationAsListCursor
                            (IGRelationAsList
                              <
                               Element, Key, ElementOps> const&);

  IGRelationAsListCursor <Element, Key, ElementOps>&
           operator=        (IGRelationAsListCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGRelationAsListCursor
                            (ICursorImpl*);

private:


};

template <class Element, class Key, class ElementOps>
class IGRelationAsList :
  public IARelation <Element, Key> {
protected:

  typedef  IGRelationAsList <Element, Key, ElementOps> Self;

  typedef  IRelationAsListImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICRelationImpl
            <PureImplementation> Implementation;
#endif

#define IGRelationAsListTypedef(Element, Key, ElementOps)\
  typedef  IRelationAsListOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGRelationAsListTypedef (Element, Key, ElementOps);

public:

  typedef  IGRelationAsListCursor
            <Element, Key, ElementOps> Cursor;


           IGRelationAsList
                            (INumber = 100);

           IGRelationAsList
                            (IGRelationAsList
                              <
                               Element, Key, ElementOps> const&);

  IGRelationAsList <Element, Key, ElementOps>&
           operator=        (IGRelationAsList
                              <
                               Element, Key, ElementOps> const&);


protected:

           IGRelationAsList
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGRelationAsList
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGRelationAsListCursor
            <Element, Key, ElementOps>;



};

template <class Element, class Key>
class IRelationAsList :
  public IGRelationAsList
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IGRelationAsList
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef  IRelationAsList <Element, Key> Self;

#define IRelationAsListTypedef(Element, Key)\
  typedef  IRelationAsListOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IRelationAsList
                            (INumber = 100);


protected:

           IRelationAsList
                              (PureImplementation&);

private:


};

template <class Element, class Key, class ElementOps>
class IVGRelationAsList :
  public IGRelationAsList
          <Element, Key, ElementOps > {

  typedef  IVGRelationAsList
            <Element, Key, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVRelationImpl
            <PureImplementation> Implementation;
#else
  typedef  ICRelationImpl
            <IVRelationImpl
              <PureImplementation> > Implementation;
#endif

#define IVGRelationAsListTypedef(Element, Key, ElementOps)\
  typedef  IRelationAsListOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGRelationAsListTypedef (Element, Key, ElementOps);

public:

           IVGRelationAsList
                            (INumber = 100);


protected:

           IVGRelationAsList
                              (PureImplementation&);

private:


};

template <class Element, class Key>
class IVRelationAsList :
  public IVGRelationAsList
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IVGRelationAsList
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef  IVRelationAsList <Element, Key> Self;

#define IVRelationAsListTypedef(Element, Key)\
  typedef  IVRelationAsListOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IVRelationAsList
                            (INumber = 100);


protected:

           IVRelationAsList
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <irellst.inl>

#pragma info (restore)
#pragma pack ()

#endif
