#ifndef _IRESLOCK_
#define _IRESLOCK_
/*******************************************************************************
* FILE NAME: ireslock.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IResource                                                                *
*     IPrivateResource                                                         *
*     ISharedResource                                                          *
*     IResourceLock                                                            *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ivbase.hpp>
#include <istring.hpp>
#include <ihandle.hpp>

class IResourceLock;
class IPrivateResource;
class ISharedResource;

#pragma pack(4)

class IResource : public IVBase {
typedef IVBase
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IResource( );
virtual
 ~IResource( );

/*----------------------------- Resource Locking -----------------------------*/
virtual IResource
 &lock           ( long timeOut = -1 ),
 &unlock         ( );

protected:
/*------------------------------ Resource Handle -----------------------------*/
virtual ISemaphoreHandle
 &handle        ( )  = 0;

private:
/*------------------------------ Hidden Members ------------------------------*/
  IResource    ( const IResource& resource );
IResource
 &operator=    ( const IResource& resource );

/*--------------------------------- Private ----------------------------------*/
IResourceLock
 *reslockGate;

long
  lClReferenceCount;

friend class IResourceLock;
friend class IPrivateResource;
friend class ISharedResource;
}; // IResource


class IPrivateResource : public IResource
{
typedef IResource
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IPrivateResource   ( );
virtual
 ~IPrivateResource   ( );

protected:
/*------------------------------ Resource Handle -----------------------------*/
ISemaphoreHandle
 &handle               ( );

private:
/*------------------------------ Hidden Members ------------------------------*/
  IPrivateResource    ( const IPrivateResource& privateResource );
IPrivateResource
 &operator=           ( const IPrivateResource& privateResource );

/*--------------------------------- Private ----------------------------------*/
ISemaphoreHandle
  resourceHandleCl;

friend class IResourceLock;
}; // IPrivateResource


class ISharedResource : public IResource
{
typedef IResource
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  ISharedResource   ( const char* keyName );
virtual
 ~ISharedResource   ( );

/*---------------------------- Resource Information --------------------------*/
IString
  keyName           ( ) const;

protected:
/*------------------------------ Resource Handle -----------------------------*/
ISemaphoreHandle
 &handle              ( );

private:
/*------------------------------ Hidden Members ------------------------------*/
  ISharedResource    ( const ISharedResource& sharedResource );
ISharedResource
 &operator=          ( const ISharedResource& sharedResource );

/*--------------------------------- Private ----------------------------------*/
ISemaphoreHandle
  resourceHandleCl;

IString
  keyNameCl;

friend class IResourceLock;
}; // ISharedResource


class IResourceLock : public IVBase
{
typedef IVBase
  Inherited;
public:

/*------------------------------- Constructors -------------------------------*/
  IResourceLock   ( IResource& resource,
                    long       timeOut = -1 );
virtual
  ~IResourceLock  ( );

protected:
/*----------------------------- Resource Locking -----------------------------*/
virtual IResourceLock
 &setLock        ( long timeOut = -1 ),
 &clearLock      ( );

private:
/*------------------------------ Hidden Members ------------------------------*/
  IResourceLock ( const IResourceLock& resourceLock );
IResourceLock
 &operator=     ( const IResourceLock& resourceLock );

/*--------------------------------- Private ----------------------------------*/
IResource
 *presCl;

friend class IResource;
}; // IResourceLock

#pragma pack()

  #include <ireslock.inl>

#endif
