/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _ISB_H
#define _ISB_H

#include <iasb.h>
#include <iicsb.h>
#include <iivsb.h>
#include <iisblst.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class ElementOps>
class IGSortedBag;

template <class Element, class ElementOps>
class IGSortedBagCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef  IGSortedBag
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGSortedBagCursor
                            (IGSortedBag
                              <
                               Element, ElementOps> const&);

  IGSortedBagCursor <Element, ElementOps>&
           operator=        (IGSortedBagCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGSortedBagCursor
                            (ICursorImpl*);

private:


};

template <class Element, class ElementOps>
class IGSortedBag :
  public IASortedBag <Element> {
protected:

  typedef  IGSortedBag <Element, ElementOps> Self;

  typedef  ISortedBagAsListImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSortedBagImpl
            <PureImplementation> Implementation;
#endif

#define IGSortedBagTypedef(Element, ElementOps)\
  typedef  ISortedBagAsListOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGSortedBagTypedef (Element, ElementOps);

public:

  typedef  IGSortedBagCursor
            <Element, ElementOps> Cursor;


           IGSortedBag
                            (INumber = 100);

           IGSortedBag
                            (IGSortedBag
                              <
                               Element, ElementOps> const&);

  IGSortedBag <Element, ElementOps>&
           operator=        (IGSortedBag
                              <
                               Element, ElementOps> const&);


protected:

           IGSortedBag
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGSortedBag
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGSortedBagCursor
            <Element, ElementOps>;



};

template <class Element>
class ISortedBag :
  public IGSortedBag
          <Element, ICOps <Element> > {

  typedef  IGSortedBag
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef  ISortedBag <Element> Self;

#define ISortedBagTypedef(Element)\
  typedef  ISortedBagAsListOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

           ISortedBag
                            (INumber = 100);


protected:

           ISortedBag
                              (PureImplementation&);

private:


};

template <class Element, class ElementOps>
class IVGSortedBag :
  public IGSortedBag
          <Element, ElementOps > {

  typedef  IVGSortedBag
            <Element, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVSortedBagImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSortedBagImpl
            <IVSortedBagImpl
              <PureImplementation> > Implementation;
#endif

#define IVGSortedBagTypedef(Element, ElementOps)\
  typedef  ISortedBagAsListOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGSortedBagTypedef (Element, ElementOps);

public:

           IVGSortedBag
                            (INumber = 100);


protected:

           IVGSortedBag
                              (PureImplementation&);

private:


};

template <class Element>
class IVSortedBag :
  public IVGSortedBag
          <Element, ICOps <Element> > {

  typedef  IVGSortedBag
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef  IVSortedBag <Element> Self;

#define IVSortedBagTypedef(Element)\
  typedef  IVSortedBagAsListOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

           IVSortedBag
                            (INumber = 100);


protected:

           IVSortedBag
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <isb.inl>

#pragma info (restore)
#pragma pack ()

#endif
