/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGSortedBagAsAvlTreeCursor
// ---

// public members

template <class Element, class ElementOps>
inline
IGSortedBagAsAvlTreeCursor <Element, ElementOps>::
IGSortedBagAsAvlTreeCursor
  (IGSortedBagAsAvlTree
    <Element, ElementOps> const& collection)
: IOrderedCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class ElementOps>
inline IGSortedBagAsAvlTreeCursor <Element, ElementOps>&
IGSortedBagAsAvlTreeCursor <Element, ElementOps>::
operator=
  (IGSortedBagAsAvlTreeCursor
    <Element, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGSortedBagAsAvlTreeCursor <Element, ElementOps>::
IGSortedBagAsAvlTreeCursor (ICursorImpl* impl)
: IOrderedCursor <Element> (impl)
{
}

// ---
// IGSortedBagAsAvlTree
// ---

// public members

template <class Element, class ElementOps>
inline
IGSortedBagAsAvlTree <Element, ElementOps>::
IGSortedBagAsAvlTree (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class ElementOps>
inline
IGSortedBagAsAvlTree <Element, ElementOps>::
IGSortedBagAsAvlTree
  (IGSortedBagAsAvlTree
    <Element, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class ElementOps>
inline IGSortedBagAsAvlTree <Element, ElementOps>&
IGSortedBagAsAvlTree <Element, ElementOps>::
operator= (IGSortedBagAsAvlTree
            <Element, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGSortedBagAsAvlTree <Element, ElementOps>::
IGSortedBagAsAvlTree (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class ElementOps>
inline IGSortedBagAsAvlTree
 <Element, ElementOps>::Implementation&
IGSortedBagAsAvlTree <Element, ElementOps>::
ImplOf (IGSortedBagAsAvlTree
         <Element, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// ISortedBagAsAvlTree
// ---

// public members

template <class Element>
inline
ISortedBagAsAvlTree <Element>::
ISortedBagAsAvlTree (INumber numberOfElements)
: IGSortedBagAsAvlTree
   <Element, ICOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
ISortedBagAsAvlTree <Element>::
ISortedBagAsAvlTree (PureImplementation& impl)
: IGSortedBagAsAvlTree
   <Element, ICOps <Element> > (impl)
{
}

// ---
// IVGSortedBagAsAvlTree
// ---

// public members

template <class Element, class ElementOps>
inline
IVGSortedBagAsAvlTree <Element, ElementOps>::
IVGSortedBagAsAvlTree (INumber numberOfElements)
: IGSortedBagAsAvlTree
    <Element, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class ElementOps>
inline
IVGSortedBagAsAvlTree <Element, ElementOps>::
IVGSortedBagAsAvlTree (PureImplementation& impl)
: IGSortedBagAsAvlTree
    <Element, ElementOps> (impl)
{
}

// ---
// IVSortedBagAsAvlTree
// ---

// public members

template <class Element>
inline
IVSortedBagAsAvlTree <Element>::
IVSortedBagAsAvlTree (INumber numberOfElements)
: IVGSortedBagAsAvlTree
   <Element, ICOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
IVSortedBagAsAvlTree <Element>::
IVSortedBagAsAvlTree (PureImplementation& impl)
: IVGSortedBagAsAvlTree
   <Element, ICOps <Element> > (impl)
{
}
