/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _ISBLST_H
#define _ISBLST_H

#include <iasb.h>
#include <iicsb.h>
#include <iivsb.h>
#include <iisblst.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class ElementOps>
class IGSortedBagAsList;

template <class Element, class ElementOps>
class IGSortedBagAsListCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef  IGSortedBagAsList
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGSortedBagAsListCursor
                            (IGSortedBagAsList
                              <
                               Element, ElementOps> const&);

  IGSortedBagAsListCursor <Element, ElementOps>&
           operator=        (IGSortedBagAsListCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGSortedBagAsListCursor
                            (ICursorImpl*);

private:


};

template <class Element, class ElementOps>
class IGSortedBagAsList :
  public IASortedBag <Element> {
protected:

  typedef  IGSortedBagAsList <Element, ElementOps> Self;

  typedef  ISortedBagAsListImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSortedBagImpl
            <PureImplementation> Implementation;
#endif

#define IGSortedBagAsListTypedef(Element, ElementOps)\
  typedef  ISortedBagAsListOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGSortedBagAsListTypedef (Element, ElementOps);

public:

  typedef  IGSortedBagAsListCursor
            <Element, ElementOps> Cursor;


           IGSortedBagAsList
                            (INumber = 100);

           IGSortedBagAsList
                            (IGSortedBagAsList
                              <
                               Element, ElementOps> const&);

  IGSortedBagAsList <Element, ElementOps>&
           operator=        (IGSortedBagAsList
                              <
                               Element, ElementOps> const&);


protected:

           IGSortedBagAsList
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGSortedBagAsList
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGSortedBagAsListCursor
            <Element, ElementOps>;



};

template <class Element>
class ISortedBagAsList :
  public IGSortedBagAsList
          <Element, ICOps <Element> > {

  typedef  IGSortedBagAsList
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef  ISortedBagAsList <Element> Self;

#define ISortedBagAsListTypedef(Element)\
  typedef  ISortedBagAsListOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

           ISortedBagAsList
                            (INumber = 100);


protected:

           ISortedBagAsList
                              (PureImplementation&);

private:


};

template <class Element, class ElementOps>
class IVGSortedBagAsList :
  public IGSortedBagAsList
          <Element, ElementOps > {

  typedef  IVGSortedBagAsList
            <Element, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVSortedBagImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSortedBagImpl
            <IVSortedBagImpl
              <PureImplementation> > Implementation;
#endif

#define IVGSortedBagAsListTypedef(Element, ElementOps)\
  typedef  ISortedBagAsListOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGSortedBagAsListTypedef (Element, ElementOps);

public:

           IVGSortedBagAsList
                            (INumber = 100);


protected:

           IVGSortedBagAsList
                              (PureImplementation&);

private:


};

template <class Element>
class IVSortedBagAsList :
  public IVGSortedBagAsList
          <Element, ICOps <Element> > {

  typedef  IVGSortedBagAsList
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef  IVSortedBagAsList <Element> Self;

#define IVSortedBagAsListTypedef(Element)\
  typedef  IVSortedBagAsListOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

           IVSortedBagAsList
                            (INumber = 100);


protected:

           IVSortedBagAsList
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <isblst.inl>

#pragma info (restore)
#pragma pack ()

#endif
