/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGSortedBagAsListCursor
// ---

// public members

template <class Element, class ElementOps>
inline
IGSortedBagAsListCursor <Element, ElementOps>::
IGSortedBagAsListCursor
  (IGSortedBagAsList
    <Element, ElementOps> const& collection)
: IOrderedCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class ElementOps>
inline IGSortedBagAsListCursor <Element, ElementOps>&
IGSortedBagAsListCursor <Element, ElementOps>::
operator=
  (IGSortedBagAsListCursor
    <Element, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGSortedBagAsListCursor <Element, ElementOps>::
IGSortedBagAsListCursor (ICursorImpl* impl)
: IOrderedCursor <Element> (impl)
{
}

// ---
// IGSortedBagAsList
// ---

// public members

template <class Element, class ElementOps>
inline
IGSortedBagAsList <Element, ElementOps>::
IGSortedBagAsList (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class ElementOps>
inline
IGSortedBagAsList <Element, ElementOps>::
IGSortedBagAsList
  (IGSortedBagAsList
    <Element, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class ElementOps>
inline IGSortedBagAsList <Element, ElementOps>&
IGSortedBagAsList <Element, ElementOps>::
operator= (IGSortedBagAsList
            <Element, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGSortedBagAsList <Element, ElementOps>::
IGSortedBagAsList (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class ElementOps>
inline IGSortedBagAsList
 <Element, ElementOps>::Implementation&
IGSortedBagAsList <Element, ElementOps>::
ImplOf (IGSortedBagAsList
         <Element, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// ISortedBagAsList
// ---

// public members

template <class Element>
inline
ISortedBagAsList <Element>::
ISortedBagAsList (INumber numberOfElements)
: IGSortedBagAsList
   <Element, ICOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
ISortedBagAsList <Element>::
ISortedBagAsList (PureImplementation& impl)
: IGSortedBagAsList
   <Element, ICOps <Element> > (impl)
{
}

// ---
// IVGSortedBagAsList
// ---

// public members

template <class Element, class ElementOps>
inline
IVGSortedBagAsList <Element, ElementOps>::
IVGSortedBagAsList (INumber numberOfElements)
: IGSortedBagAsList
    <Element, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class ElementOps>
inline
IVGSortedBagAsList <Element, ElementOps>::
IVGSortedBagAsList (PureImplementation& impl)
: IGSortedBagAsList
    <Element, ElementOps> (impl)
{
}

// ---
// IVSortedBagAsList
// ---

// public members

template <class Element>
inline
IVSortedBagAsList <Element>::
IVSortedBagAsList (INumber numberOfElements)
: IVGSortedBagAsList
   <Element, ICOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
IVSortedBagAsList <Element>::
IVSortedBagAsList (PureImplementation& impl)
: IVGSortedBagAsList
   <Element, ICOps <Element> > (impl)
{
}
