/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGSortedBagAsTableCursor
// ---

// public members

template <class Element, class ElementOps>
inline
IGSortedBagAsTableCursor <Element, ElementOps>::
IGSortedBagAsTableCursor
  (IGSortedBagAsTable
    <Element, ElementOps> const& collection)
: IOrderedCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class ElementOps>
inline IGSortedBagAsTableCursor <Element, ElementOps>&
IGSortedBagAsTableCursor <Element, ElementOps>::
operator=
  (IGSortedBagAsTableCursor
    <Element, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGSortedBagAsTableCursor <Element, ElementOps>::
IGSortedBagAsTableCursor (ICursorImpl* impl)
: IOrderedCursor <Element> (impl)
{
}

// ---
// IGSortedBagAsTable
// ---

// public members

template <class Element, class ElementOps>
inline
IGSortedBagAsTable <Element, ElementOps>::
IGSortedBagAsTable (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class ElementOps>
inline
IGSortedBagAsTable <Element, ElementOps>::
IGSortedBagAsTable
  (IGSortedBagAsTable
    <Element, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class ElementOps>
inline IGSortedBagAsTable <Element, ElementOps>&
IGSortedBagAsTable <Element, ElementOps>::
operator= (IGSortedBagAsTable
            <Element, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGSortedBagAsTable <Element, ElementOps>::
IGSortedBagAsTable (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class ElementOps>
inline IGSortedBagAsTable
 <Element, ElementOps>::Implementation&
IGSortedBagAsTable <Element, ElementOps>::
ImplOf (IGSortedBagAsTable
         <Element, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// ISortedBagAsTable
// ---

// public members

template <class Element>
inline
ISortedBagAsTable <Element>::
ISortedBagAsTable (INumber numberOfElements)
: IGSortedBagAsTable
   <Element, ICOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
ISortedBagAsTable <Element>::
ISortedBagAsTable (PureImplementation& impl)
: IGSortedBagAsTable
   <Element, ICOps <Element> > (impl)
{
}

// ---
// IVGSortedBagAsTable
// ---

// public members

template <class Element, class ElementOps>
inline
IVGSortedBagAsTable <Element, ElementOps>::
IVGSortedBagAsTable (INumber numberOfElements)
: IGSortedBagAsTable
    <Element, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class ElementOps>
inline
IVGSortedBagAsTable <Element, ElementOps>::
IVGSortedBagAsTable (PureImplementation& impl)
: IGSortedBagAsTable
    <Element, ElementOps> (impl)
{
}

// ---
// IVSortedBagAsTable
// ---

// public members

template <class Element>
inline
IVSortedBagAsTable <Element>::
IVSortedBagAsTable (INumber numberOfElements)
: IVGSortedBagAsTable
   <Element, ICOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
IVSortedBagAsTable <Element>::
IVSortedBagAsTable (PureImplementation& impl)
: IVGSortedBagAsTable
   <Element, ICOps <Element> > (impl)
{
}
