/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _ISEQ_H
#define _ISEQ_H

#include <iaseq.h>
#include <iicseq.h>
#include <iivseq.h>
#include <iiseqlst.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class ElementOps>
class IGSequence;

template <class Element, class ElementOps>
class IGSequenceCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef  IGSequence
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGSequenceCursor
                            (IGSequence
                              <
                               Element, ElementOps> const&);

  IGSequenceCursor <Element, ElementOps>&
           operator=        (IGSequenceCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGSequenceCursor
                            (ICursorImpl*);

private:


};

template <class Element, class ElementOps>
class IGSequence :
  public IASequence <Element> {
protected:

  typedef  IGSequence <Element, ElementOps> Self;

  typedef  ISequenceAsListImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSequenceImpl
            <PureImplementation> Implementation;
#endif

#define IGSequenceTypedef(Element, ElementOps)\
  typedef  ISequenceAsListOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGSequenceTypedef (Element, ElementOps);

public:

  typedef  IGSequenceCursor
            <Element, ElementOps> Cursor;


           IGSequence
                            (INumber = 100);

           IGSequence
                            (IGSequence
                              <
                               Element, ElementOps> const&);

  IGSequence <Element, ElementOps>&
           operator=        (IGSequence
                              <
                               Element, ElementOps> const&);


protected:

           IGSequence
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGSequence
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGSequenceCursor
            <Element, ElementOps>;



};

template <class Element>
class ISequence :
  public IGSequence
          <Element, IStdOps <Element> > {

  typedef  IGSequence
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef  ISequence <Element> Self;

#define ISequenceTypedef(Element)\
  typedef  ISequenceAsListOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

           ISequence
                            (INumber = 100);


protected:

           ISequence
                              (PureImplementation&);

private:


};

template <class Element, class ElementOps>
class IVGSequence :
  public IGSequence
          <Element, ElementOps > {

  typedef  IVGSequence
            <Element, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVSequenceImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSequenceImpl
            <IVSequenceImpl
              <PureImplementation> > Implementation;
#endif

#define IVGSequenceTypedef(Element, ElementOps)\
  typedef  ISequenceAsListOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGSequenceTypedef (Element, ElementOps);

public:

           IVGSequence
                            (INumber = 100);


protected:

           IVGSequence
                              (PureImplementation&);

private:


};

template <class Element>
class IVSequence :
  public IVGSequence
          <Element, IStdOps <Element> > {

  typedef  IVGSequence
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef  IVSequence <Element> Self;

#define IVSequenceTypedef(Element)\
  typedef  IVSequenceAsListOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

           IVSequence
                            (INumber = 100);


protected:

           IVSequence
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <iseq.inl>

#pragma info (restore)
#pragma pack ()

#endif
