/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGSequenceCursor
// ---

// public members

template <class Element, class ElementOps>
inline
IGSequenceCursor <Element, ElementOps>::
IGSequenceCursor
  (IGSequence
    <Element, ElementOps> const& collection)
: IOrderedCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class ElementOps>
inline IGSequenceCursor <Element, ElementOps>&
IGSequenceCursor <Element, ElementOps>::
operator=
  (IGSequenceCursor
    <Element, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGSequenceCursor <Element, ElementOps>::
IGSequenceCursor (ICursorImpl* impl)
: IOrderedCursor <Element> (impl)
{
}

// ---
// IGSequence
// ---

// public members

template <class Element, class ElementOps>
inline
IGSequence <Element, ElementOps>::
IGSequence (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class ElementOps>
inline
IGSequence <Element, ElementOps>::
IGSequence
  (IGSequence
    <Element, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class ElementOps>
inline IGSequence <Element, ElementOps>&
IGSequence <Element, ElementOps>::
operator= (IGSequence
            <Element, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGSequence <Element, ElementOps>::
IGSequence (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class ElementOps>
inline IGSequence
 <Element, ElementOps>::Implementation&
IGSequence <Element, ElementOps>::
ImplOf (IGSequence
         <Element, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// ISequence
// ---

// public members

template <class Element>
inline
ISequence <Element>::
ISequence (INumber numberOfElements)
: IGSequence
   <Element, IStdOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
ISequence <Element>::
ISequence (PureImplementation& impl)
: IGSequence
   <Element, IStdOps <Element> > (impl)
{
}

// ---
// IVGSequence
// ---

// public members

template <class Element, class ElementOps>
inline
IVGSequence <Element, ElementOps>::
IVGSequence (INumber numberOfElements)
: IGSequence
    <Element, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class ElementOps>
inline
IVGSequence <Element, ElementOps>::
IVGSequence (PureImplementation& impl)
: IGSequence
    <Element, ElementOps> (impl)
{
}

// ---
// IVSequence
// ---

// public members

template <class Element>
inline
IVSequence <Element>::
IVSequence (INumber numberOfElements)
: IVGSequence
   <Element, IStdOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
IVSequence <Element>::
IVSequence (PureImplementation& impl)
: IVGSequence
   <Element, IStdOps <Element> > (impl)
{
}
