/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _ISEQDIL_H
#define _ISEQDIL_H

#include <iaseq.h>
#include <iicseq.h>
#include <iivseq.h>
#include <iiseqdil.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class ElementOps>
class IGSequenceAsDilTable;

template <class Element, class ElementOps>
class IGSequenceAsDilTableCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef  IGSequenceAsDilTable
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGSequenceAsDilTableCursor
                            (IGSequenceAsDilTable
                              <
                               Element, ElementOps> const&);

  IGSequenceAsDilTableCursor <Element, ElementOps>&
           operator=        (IGSequenceAsDilTableCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGSequenceAsDilTableCursor
                            (ICursorImpl*);

private:


};

template <class Element, class ElementOps>
class IGSequenceAsDilTable :
  public IASequence <Element> {
protected:

  typedef  IGSequenceAsDilTable <Element, ElementOps> Self;

  typedef  ISequenceAsDilTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSequenceImpl
            <PureImplementation> Implementation;
#endif

#define IGSequenceAsDilTableTypedef(Element, ElementOps)\
  typedef  ISequenceAsDilTableOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGSequenceAsDilTableTypedef (Element, ElementOps);

public:

  typedef  IGSequenceAsDilTableCursor
            <Element, ElementOps> Cursor;


           IGSequenceAsDilTable
                            (INumber = 100);

           IGSequenceAsDilTable
                            (IGSequenceAsDilTable
                              <
                               Element, ElementOps> const&);

  IGSequenceAsDilTable <Element, ElementOps>&
           operator=        (IGSequenceAsDilTable
                              <
                               Element, ElementOps> const&);


protected:

           IGSequenceAsDilTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGSequenceAsDilTable
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGSequenceAsDilTableCursor
            <Element, ElementOps>;



};

template <class Element>
class ISequenceAsDilTable :
  public IGSequenceAsDilTable
          <Element, IStdOps <Element> > {

  typedef  IGSequenceAsDilTable
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef  ISequenceAsDilTable <Element> Self;

#define ISequenceAsDilTableTypedef(Element)\
  typedef  ISequenceAsDilTableOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

           ISequenceAsDilTable
                            (INumber = 100);


protected:

           ISequenceAsDilTable
                              (PureImplementation&);

private:


};

template <class Element, class ElementOps>
class IVGSequenceAsDilTable :
  public IGSequenceAsDilTable
          <Element, ElementOps > {

  typedef  IVGSequenceAsDilTable
            <Element, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVSequenceImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSequenceImpl
            <IVSequenceImpl
              <PureImplementation> > Implementation;
#endif

#define IVGSequenceAsDilTableTypedef(Element, ElementOps)\
  typedef  ISequenceAsDilTableOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGSequenceAsDilTableTypedef (Element, ElementOps);

public:

           IVGSequenceAsDilTable
                            (INumber = 100);


protected:

           IVGSequenceAsDilTable
                              (PureImplementation&);

private:


};

template <class Element>
class IVSequenceAsDilTable :
  public IVGSequenceAsDilTable
          <Element, IStdOps <Element> > {

  typedef  IVGSequenceAsDilTable
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef  IVSequenceAsDilTable <Element> Self;

#define IVSequenceAsDilTableTypedef(Element)\
  typedef  IVSequenceAsDilTableOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

           IVSequenceAsDilTable
                            (INumber = 100);


protected:

           IVSequenceAsDilTable
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <iseqdil.inl>

#pragma info (restore)
#pragma pack ()

#endif
