/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGSequenceAsDilTableCursor
// ---

// public members

template <class Element, class ElementOps>
inline
IGSequenceAsDilTableCursor <Element, ElementOps>::
IGSequenceAsDilTableCursor
  (IGSequenceAsDilTable
    <Element, ElementOps> const& collection)
: IOrderedCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class ElementOps>
inline IGSequenceAsDilTableCursor <Element, ElementOps>&
IGSequenceAsDilTableCursor <Element, ElementOps>::
operator=
  (IGSequenceAsDilTableCursor
    <Element, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGSequenceAsDilTableCursor <Element, ElementOps>::
IGSequenceAsDilTableCursor (ICursorImpl* impl)
: IOrderedCursor <Element> (impl)
{
}

// ---
// IGSequenceAsDilTable
// ---

// public members

template <class Element, class ElementOps>
inline
IGSequenceAsDilTable <Element, ElementOps>::
IGSequenceAsDilTable (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class ElementOps>
inline
IGSequenceAsDilTable <Element, ElementOps>::
IGSequenceAsDilTable
  (IGSequenceAsDilTable
    <Element, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class ElementOps>
inline IGSequenceAsDilTable <Element, ElementOps>&
IGSequenceAsDilTable <Element, ElementOps>::
operator= (IGSequenceAsDilTable
            <Element, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGSequenceAsDilTable <Element, ElementOps>::
IGSequenceAsDilTable (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class ElementOps>
inline IGSequenceAsDilTable
 <Element, ElementOps>::Implementation&
IGSequenceAsDilTable <Element, ElementOps>::
ImplOf (IGSequenceAsDilTable
         <Element, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// ISequenceAsDilTable
// ---

// public members

template <class Element>
inline
ISequenceAsDilTable <Element>::
ISequenceAsDilTable (INumber numberOfElements)
: IGSequenceAsDilTable
   <Element, IStdOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
ISequenceAsDilTable <Element>::
ISequenceAsDilTable (PureImplementation& impl)
: IGSequenceAsDilTable
   <Element, IStdOps <Element> > (impl)
{
}

// ---
// IVGSequenceAsDilTable
// ---

// public members

template <class Element, class ElementOps>
inline
IVGSequenceAsDilTable <Element, ElementOps>::
IVGSequenceAsDilTable (INumber numberOfElements)
: IGSequenceAsDilTable
    <Element, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class ElementOps>
inline
IVGSequenceAsDilTable <Element, ElementOps>::
IVGSequenceAsDilTable (PureImplementation& impl)
: IGSequenceAsDilTable
    <Element, ElementOps> (impl)
{
}

// ---
// IVSequenceAsDilTable
// ---

// public members

template <class Element>
inline
IVSequenceAsDilTable <Element>::
IVSequenceAsDilTable (INumber numberOfElements)
: IVGSequenceAsDilTable
   <Element, IStdOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
IVSequenceAsDilTable <Element>::
IVSequenceAsDilTable (PureImplementation& impl)
: IVGSequenceAsDilTable
   <Element, IStdOps <Element> > (impl)
{
}
