/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _ISEQLST_H
#define _ISEQLST_H

#include <iaseq.h>
#include <iicseq.h>
#include <iivseq.h>
#include <iiseqlst.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class ElementOps>
class IGSequenceAsList;

template <class Element, class ElementOps>
class IGSequenceAsListCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef  IGSequenceAsList
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGSequenceAsListCursor
                            (IGSequenceAsList
                              <
                               Element, ElementOps> const&);

  IGSequenceAsListCursor <Element, ElementOps>&
           operator=        (IGSequenceAsListCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGSequenceAsListCursor
                            (ICursorImpl*);

private:


};

template <class Element, class ElementOps>
class IGSequenceAsList :
  public IASequence <Element> {
protected:

  typedef  IGSequenceAsList <Element, ElementOps> Self;

  typedef  ISequenceAsListImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSequenceImpl
            <PureImplementation> Implementation;
#endif

#define IGSequenceAsListTypedef(Element, ElementOps)\
  typedef  ISequenceAsListOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGSequenceAsListTypedef (Element, ElementOps);

public:

  typedef  IGSequenceAsListCursor
            <Element, ElementOps> Cursor;


           IGSequenceAsList
                            (INumber = 100);

           IGSequenceAsList
                            (IGSequenceAsList
                              <
                               Element, ElementOps> const&);

  IGSequenceAsList <Element, ElementOps>&
           operator=        (IGSequenceAsList
                              <
                               Element, ElementOps> const&);


protected:

           IGSequenceAsList
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGSequenceAsList
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGSequenceAsListCursor
            <Element, ElementOps>;



};

template <class Element>
class ISequenceAsList :
  public IGSequenceAsList
          <Element, IStdOps <Element> > {

  typedef  IGSequenceAsList
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef  ISequenceAsList <Element> Self;

#define ISequenceAsListTypedef(Element)\
  typedef  ISequenceAsListOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

           ISequenceAsList
                            (INumber = 100);


protected:

           ISequenceAsList
                              (PureImplementation&);

private:


};

template <class Element, class ElementOps>
class IVGSequenceAsList :
  public IGSequenceAsList
          <Element, ElementOps > {

  typedef  IVGSequenceAsList
            <Element, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVSequenceImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSequenceImpl
            <IVSequenceImpl
              <PureImplementation> > Implementation;
#endif

#define IVGSequenceAsListTypedef(Element, ElementOps)\
  typedef  ISequenceAsListOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGSequenceAsListTypedef (Element, ElementOps);

public:

           IVGSequenceAsList
                            (INumber = 100);


protected:

           IVGSequenceAsList
                              (PureImplementation&);

private:


};

template <class Element>
class IVSequenceAsList :
  public IVGSequenceAsList
          <Element, IStdOps <Element> > {

  typedef  IVGSequenceAsList
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef  IVSequenceAsList <Element> Self;

#define IVSequenceAsListTypedef(Element)\
  typedef  IVSequenceAsListOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

           IVSequenceAsList
                            (INumber = 100);


protected:

           IVSequenceAsList
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <iseqlst.inl>

#pragma info (restore)
#pragma pack ()

#endif
