/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGSetCursor
// ---

// public members

template <class Element, class ElementOps>
inline
IGSetCursor <Element, ElementOps>::
IGSetCursor
  (IGSet
    <Element, ElementOps> const& collection)
: IElementCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class ElementOps>
inline IGSetCursor <Element, ElementOps>&
IGSetCursor <Element, ElementOps>::
operator=
  (IGSetCursor
    <Element, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGSetCursor <Element, ElementOps>::
IGSetCursor (ICursorImpl* impl)
: IElementCursor <Element> (impl)
{
}

// ---
// IGSet
// ---

// public members

template <class Element, class ElementOps>
inline
IGSet <Element, ElementOps>::
IGSet (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class ElementOps>
inline
IGSet <Element, ElementOps>::
IGSet
  (IGSet
    <Element, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class ElementOps>
inline IGSet <Element, ElementOps>&
IGSet <Element, ElementOps>::
operator= (IGSet
            <Element, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGSet <Element, ElementOps>::
IGSet (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class ElementOps>
inline IGSet
 <Element, ElementOps>::Implementation&
IGSet <Element, ElementOps>::
ImplOf (IGSet
         <Element, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// ISet
// ---

// public members

template <class Element>
inline
ISet <Element>::
ISet (INumber numberOfElements)
: IGSet
   <Element, ICOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
ISet <Element>::
ISet (PureImplementation& impl)
: IGSet
   <Element, ICOps <Element> > (impl)
{
}

// ---
// IVGSet
// ---

// public members

template <class Element, class ElementOps>
inline
IVGSet <Element, ElementOps>::
IVGSet (INumber numberOfElements)
: IGSet
    <Element, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class ElementOps>
inline
IVGSet <Element, ElementOps>::
IVGSet (PureImplementation& impl)
: IGSet
    <Element, ElementOps> (impl)
{
}

// ---
// IVSet
// ---

// public members

template <class Element>
inline
IVSet <Element>::
IVSet (INumber numberOfElements)
: IVGSet
   <Element, ICOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
IVSet <Element>::
IVSet (PureImplementation& impl)
: IVGSet
   <Element, ICOps <Element> > (impl)
{
}
