/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGSetAsAvlTreeCursor
// ---

// public members

template <class Element, class ElementOps>
inline
IGSetAsAvlTreeCursor <Element, ElementOps>::
IGSetAsAvlTreeCursor
  (IGSetAsAvlTree
    <Element, ElementOps> const& collection)
: IElementCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class ElementOps>
inline IGSetAsAvlTreeCursor <Element, ElementOps>&
IGSetAsAvlTreeCursor <Element, ElementOps>::
operator=
  (IGSetAsAvlTreeCursor
    <Element, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGSetAsAvlTreeCursor <Element, ElementOps>::
IGSetAsAvlTreeCursor (ICursorImpl* impl)
: IElementCursor <Element> (impl)
{
}

// ---
// IGSetAsAvlTree
// ---

// public members

template <class Element, class ElementOps>
inline
IGSetAsAvlTree <Element, ElementOps>::
IGSetAsAvlTree (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class ElementOps>
inline
IGSetAsAvlTree <Element, ElementOps>::
IGSetAsAvlTree
  (IGSetAsAvlTree
    <Element, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class ElementOps>
inline IGSetAsAvlTree <Element, ElementOps>&
IGSetAsAvlTree <Element, ElementOps>::
operator= (IGSetAsAvlTree
            <Element, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGSetAsAvlTree <Element, ElementOps>::
IGSetAsAvlTree (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class ElementOps>
inline IGSetAsAvlTree
 <Element, ElementOps>::Implementation&
IGSetAsAvlTree <Element, ElementOps>::
ImplOf (IGSetAsAvlTree
         <Element, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// ISetAsAvlTree
// ---

// public members

template <class Element>
inline
ISetAsAvlTree <Element>::
ISetAsAvlTree (INumber numberOfElements)
: IGSetAsAvlTree
   <Element, ICOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
ISetAsAvlTree <Element>::
ISetAsAvlTree (PureImplementation& impl)
: IGSetAsAvlTree
   <Element, ICOps <Element> > (impl)
{
}

// ---
// IVGSetAsAvlTree
// ---

// public members

template <class Element, class ElementOps>
inline
IVGSetAsAvlTree <Element, ElementOps>::
IVGSetAsAvlTree (INumber numberOfElements)
: IGSetAsAvlTree
    <Element, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class ElementOps>
inline
IVGSetAsAvlTree <Element, ElementOps>::
IVGSetAsAvlTree (PureImplementation& impl)
: IGSetAsAvlTree
    <Element, ElementOps> (impl)
{
}

// ---
// IVSetAsAvlTree
// ---

// public members

template <class Element>
inline
IVSetAsAvlTree <Element>::
IVSetAsAvlTree (INumber numberOfElements)
: IVGSetAsAvlTree
   <Element, ICOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
IVSetAsAvlTree <Element>::
IVSetAsAvlTree (PureImplementation& impl)
: IVGSetAsAvlTree
   <Element, ICOps <Element> > (impl)
{
}
