#ifndef _ISETBUT_
  #define _ISETBUT_
/*******************************************************************************
* FILE NAME: isetbut.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     ISetttingButtton                                                         *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ibutton.hpp>

class ISettingButtonData;

#pragma pack(4)

class ISettingButton : public IButton  {
typedef IButton
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  ISettingButton ( );
virtual
 ~ISettingButton ( );

/*-------------------------------- Selection ---------------------------------*/
Boolean
  isSelected     ( ) const;
virtual ISettingButton
 &select         ( Boolean select = true ),
 &deselect       ( );

/*------------------------------- Auto Select --------------------------------*/
virtual ISettingButton&
  enableAutoSelect  ( Boolean enable ) = 0;
virtual ISettingButton&
  disableAutoSelect ( )                = 0;
virtual Boolean
  isAutoSelect      ( ) const          = 0;

/*--------------------- Notification Event Descriptions ----------------------*/
static INotificationId const
  IC_IMPORTU selectId;

/*-------------------------- Observer Notification ---------------------------*/
virtual ISettingButton
 &enableNotification ( Boolean enable = true );

protected:
/*---------------------- Event Handling Implementation -----------------------*/

private:
/*--------------------------------- Private ----------------------------------*/
ISettingButtonData
 *fSettingButtonData;

/*----------------------------- Hidden Functions -----------------------------*/
  ISettingButton     ( const ISettingButton& );
ISettingButton
 &operator=          ( const ISettingButton& );
};  // class ISettingButton

#pragma pack()

#endif  /* _ISETBUT_ */
