/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGSetAsDilTableCursor
// ---

// public members

template <class Element, class ElementOps>
inline
IGSetAsDilTableCursor <Element, ElementOps>::
IGSetAsDilTableCursor
  (IGSetAsDilTable
    <Element, ElementOps> const& collection)
: IElementCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class ElementOps>
inline IGSetAsDilTableCursor <Element, ElementOps>&
IGSetAsDilTableCursor <Element, ElementOps>::
operator=
  (IGSetAsDilTableCursor
    <Element, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGSetAsDilTableCursor <Element, ElementOps>::
IGSetAsDilTableCursor (ICursorImpl* impl)
: IElementCursor <Element> (impl)
{
}

// ---
// IGSetAsDilTable
// ---

// public members

template <class Element, class ElementOps>
inline
IGSetAsDilTable <Element, ElementOps>::
IGSetAsDilTable (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class ElementOps>
inline
IGSetAsDilTable <Element, ElementOps>::
IGSetAsDilTable
  (IGSetAsDilTable
    <Element, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class ElementOps>
inline IGSetAsDilTable <Element, ElementOps>&
IGSetAsDilTable <Element, ElementOps>::
operator= (IGSetAsDilTable
            <Element, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGSetAsDilTable <Element, ElementOps>::
IGSetAsDilTable (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class ElementOps>
inline IGSetAsDilTable
 <Element, ElementOps>::Implementation&
IGSetAsDilTable <Element, ElementOps>::
ImplOf (IGSetAsDilTable
         <Element, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// ISetAsDilTable
// ---

// public members

template <class Element>
inline
ISetAsDilTable <Element>::
ISetAsDilTable (INumber numberOfElements)
: IGSetAsDilTable
   <Element, ICOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
ISetAsDilTable <Element>::
ISetAsDilTable (PureImplementation& impl)
: IGSetAsDilTable
   <Element, ICOps <Element> > (impl)
{
}

// ---
// IVGSetAsDilTable
// ---

// public members

template <class Element, class ElementOps>
inline
IVGSetAsDilTable <Element, ElementOps>::
IVGSetAsDilTable (INumber numberOfElements)
: IGSetAsDilTable
    <Element, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class ElementOps>
inline
IVGSetAsDilTable <Element, ElementOps>::
IVGSetAsDilTable (PureImplementation& impl)
: IGSetAsDilTable
    <Element, ElementOps> (impl)
{
}

// ---
// IVSetAsDilTable
// ---

// public members

template <class Element>
inline
IVSetAsDilTable <Element>::
IVSetAsDilTable (INumber numberOfElements)
: IVGSetAsDilTable
   <Element, ICOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
IVSetAsDilTable <Element>::
IVSetAsDilTable (PureImplementation& impl)
: IVGSetAsDilTable
   <Element, ICOps <Element> > (impl)
{
}
