/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGSetAsHshTableCursor
// ---

// public members

template <class Element, class ElementOps>
inline
IGSetAsHshTableCursor <Element, ElementOps>::
IGSetAsHshTableCursor
  (IGSetAsHshTable
    <Element, ElementOps> const& collection)
: IElementCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class ElementOps>
inline IGSetAsHshTableCursor <Element, ElementOps>&
IGSetAsHshTableCursor <Element, ElementOps>::
operator=
  (IGSetAsHshTableCursor
    <Element, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGSetAsHshTableCursor <Element, ElementOps>::
IGSetAsHshTableCursor (ICursorImpl* impl)
: IElementCursor <Element> (impl)
{
}

// ---
// IGSetAsHshTable
// ---

// public members

template <class Element, class ElementOps>
inline
IGSetAsHshTable <Element, ElementOps>::
IGSetAsHshTable (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class ElementOps>
inline
IGSetAsHshTable <Element, ElementOps>::
IGSetAsHshTable
  (IGSetAsHshTable
    <Element, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class ElementOps>
inline IGSetAsHshTable <Element, ElementOps>&
IGSetAsHshTable <Element, ElementOps>::
operator= (IGSetAsHshTable
            <Element, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGSetAsHshTable <Element, ElementOps>::
IGSetAsHshTable (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class ElementOps>
inline IGSetAsHshTable
 <Element, ElementOps>::Implementation&
IGSetAsHshTable <Element, ElementOps>::
ImplOf (IGSetAsHshTable
         <Element, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// ISetAsHshTable
// ---

// public members

template <class Element>
inline
ISetAsHshTable <Element>::
ISetAsHshTable (INumber numberOfElements)
: IGSetAsHshTable
   <Element, IEHOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
ISetAsHshTable <Element>::
ISetAsHshTable (PureImplementation& impl)
: IGSetAsHshTable
   <Element, IEHOps <Element> > (impl)
{
}

// ---
// IVGSetAsHshTable
// ---

// public members

template <class Element, class ElementOps>
inline
IVGSetAsHshTable <Element, ElementOps>::
IVGSetAsHshTable (INumber numberOfElements)
: IGSetAsHshTable
    <Element, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class ElementOps>
inline
IVGSetAsHshTable <Element, ElementOps>::
IVGSetAsHshTable (PureImplementation& impl)
: IGSetAsHshTable
    <Element, ElementOps> (impl)
{
}

// ---
// IVSetAsHshTable
// ---

// public members

template <class Element>
inline
IVSetAsHshTable <Element>::
IVSetAsHshTable (INumber numberOfElements)
: IVGSetAsHshTable
   <Element, IEHOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
IVSetAsHshTable <Element>::
IVSetAsHshTable (PureImplementation& impl)
: IVGSetAsHshTable
   <Element, IEHOps <Element> > (impl)
{
}
