/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _ISETTAB_H
#define _ISETTAB_H

#include <iaset.h>
#include <iicset.h>
#include <iivset.h>
#include <iisettab.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class ElementOps>
class IGSetAsTable;

template <class Element, class ElementOps>
class IGSetAsTableCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef  IGSetAsTable
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGSetAsTableCursor
                            (IGSetAsTable
                              <
                               Element, ElementOps> const&);

  IGSetAsTableCursor <Element, ElementOps>&
           operator=        (IGSetAsTableCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGSetAsTableCursor
                            (ICursorImpl*);

private:


};

template <class Element, class ElementOps>
class IGSetAsTable :
  public IASet <Element> {
protected:

  typedef  IGSetAsTable <Element, ElementOps> Self;

  typedef  ISetAsTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSetImpl
            <PureImplementation> Implementation;
#endif

#define IGSetAsTableTypedef(Element, ElementOps)\
  typedef  ISetAsTableOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGSetAsTableTypedef (Element, ElementOps);

public:

  typedef  IGSetAsTableCursor
            <Element, ElementOps> Cursor;


           IGSetAsTable
                            (INumber = 100);

           IGSetAsTable
                            (IGSetAsTable
                              <
                               Element, ElementOps> const&);

  IGSetAsTable <Element, ElementOps>&
           operator=        (IGSetAsTable
                              <
                               Element, ElementOps> const&);


protected:

           IGSetAsTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGSetAsTable
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGSetAsTableCursor
            <Element, ElementOps>;



};

template <class Element>
class ISetAsTable :
  public IGSetAsTable
          <Element, ICOps <Element> > {

  typedef  IGSetAsTable
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef  ISetAsTable <Element> Self;

#define ISetAsTableTypedef(Element)\
  typedef  ISetAsTableOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

           ISetAsTable
                            (INumber = 100);


protected:

           ISetAsTable
                              (PureImplementation&);

private:


};

template <class Element, class ElementOps>
class IVGSetAsTable :
  public IGSetAsTable
          <Element, ElementOps > {

  typedef  IVGSetAsTable
            <Element, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVSetImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSetImpl
            <IVSetImpl
              <PureImplementation> > Implementation;
#endif

#define IVGSetAsTableTypedef(Element, ElementOps)\
  typedef  ISetAsTableOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGSetAsTableTypedef (Element, ElementOps);

public:

           IVGSetAsTable
                            (INumber = 100);


protected:

           IVGSetAsTable
                              (PureImplementation&);

private:


};

template <class Element>
class IVSetAsTable :
  public IVGSetAsTable
          <Element, ICOps <Element> > {

  typedef  IVGSetAsTable
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef  IVSetAsTable <Element> Self;

#define IVSetAsTableTypedef(Element)\
  typedef  IVSetAsTableOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

           IVSetAsTable
                            (INumber = 100);


protected:

           IVSetAsTable
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <isettab.inl>

#pragma info (restore)
#pragma pack ()

#endif
