/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGSetAsTableCursor
// ---

// public members

template <class Element, class ElementOps>
inline
IGSetAsTableCursor <Element, ElementOps>::
IGSetAsTableCursor
  (IGSetAsTable
    <Element, ElementOps> const& collection)
: IElementCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class ElementOps>
inline IGSetAsTableCursor <Element, ElementOps>&
IGSetAsTableCursor <Element, ElementOps>::
operator=
  (IGSetAsTableCursor
    <Element, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGSetAsTableCursor <Element, ElementOps>::
IGSetAsTableCursor (ICursorImpl* impl)
: IElementCursor <Element> (impl)
{
}

// ---
// IGSetAsTable
// ---

// public members

template <class Element, class ElementOps>
inline
IGSetAsTable <Element, ElementOps>::
IGSetAsTable (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class ElementOps>
inline
IGSetAsTable <Element, ElementOps>::
IGSetAsTable
  (IGSetAsTable
    <Element, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class ElementOps>
inline IGSetAsTable <Element, ElementOps>&
IGSetAsTable <Element, ElementOps>::
operator= (IGSetAsTable
            <Element, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGSetAsTable <Element, ElementOps>::
IGSetAsTable (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class ElementOps>
inline IGSetAsTable
 <Element, ElementOps>::Implementation&
IGSetAsTable <Element, ElementOps>::
ImplOf (IGSetAsTable
         <Element, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// ISetAsTable
// ---

// public members

template <class Element>
inline
ISetAsTable <Element>::
ISetAsTable (INumber numberOfElements)
: IGSetAsTable
   <Element, ICOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
ISetAsTable <Element>::
ISetAsTable (PureImplementation& impl)
: IGSetAsTable
   <Element, ICOps <Element> > (impl)
{
}

// ---
// IVGSetAsTable
// ---

// public members

template <class Element, class ElementOps>
inline
IVGSetAsTable <Element, ElementOps>::
IVGSetAsTable (INumber numberOfElements)
: IGSetAsTable
    <Element, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class ElementOps>
inline
IVGSetAsTable <Element, ElementOps>::
IVGSetAsTable (PureImplementation& impl)
: IGSetAsTable
    <Element, ElementOps> (impl)
{
}

// ---
// IVSetAsTable
// ---

// public members

template <class Element>
inline
IVSetAsTable <Element>::
IVSetAsTable (INumber numberOfElements)
: IVGSetAsTable
   <Element, ICOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
IVSetAsTable <Element>::
IVSetAsTable (PureImplementation& impl)
: IVGSetAsTable
   <Element, ICOps <Element> > (impl)
{
}
