#ifndef _ISLIDER_
#define _ISLIDER_
/*******************************************************************************
* FILE NAME: islider.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     ISlider                                                                  *
*     IProgressIndicator                                                       *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <icontrol.hpp>

class IPoint;
class ISize;
class IString;
class IRectangle;
class IColor;
class IWindowHandle;
class IResourceId;
class IProgressIndicatorData;
class ISliderData;

#pragma pack(4)

class IProgressIndicator : public IControl  {
typedef IControl
  Inherited;

public:
class Style;

/*------------------------------ Constructors --------------------------------*/
  IProgressIndicator  ( unsigned long        windowId,
                        IWindow*             parent,
                        IWindow*             owner,
                        const IRectangle&    initial,
                        unsigned long        numberOfTicks,
                        unsigned long        tickSpacing = 0,
                        const Style&         style = defaultStyle() );
  IProgressIndicator  ( unsigned long        windowId,
                        IWindow*             parent,
                        IWindow*             owner,
                        const IRectangle&    initial,
                        unsigned long        scale1NumberOfTicks,
                        unsigned long        scale1TickSpacing,
                        unsigned long        scale2NumberOfTicks,
                        unsigned long        scale2TickSpacing = 0,
                        const Style&         style = defaultStyle() );
  IProgressIndicator  ( unsigned long        windowId,
                        IWindow*             parent );
  IProgressIndicator  ( const IWindowHandle& handle );

virtual
 ~IProgressIndicator  ( );

/*---------------------------------- Styles ----------------------------------*/
INESTEDBITFLAGCLASSDEF2(Style, IProgressIndicator, IWindow, IControl);

static const Style
  IC_IMPORTU classDefaultStyle,
  IC_IMPORTU pmCompatible,
  IC_IMPORTU horizontal,
  IC_IMPORTU vertical,
  IC_IMPORTU alignCentered,
  IC_IMPORTU alignTop,
  IC_IMPORTU alignBottom,
  IC_IMPORTU alignLeft,
  IC_IMPORTU alignRight,
  IC_IMPORTU homeTop,
  IC_IMPORTU homeBottom,
  IC_IMPORTU homeLeft,
  IC_IMPORTU homeRight,
  IC_IMPORTU primaryScale1,
  IC_IMPORTU primaryScale2,
  IC_IMPORTU snapToTickMark,
  IC_IMPORTU ribbonStrip;
static const Style
  IC_IMPORTU handleDrawItem;
#ifndef IC_MOTIFPM_FLAGNOP
static const Style
  IC_IMPORTU border3D;
#endif

static Style
  defaultStyle      ( );

static void
  setDefaultStyle   ( const Style&    style );

virtual unsigned long
  convertToGUIStyle ( const IBitFlag& style,
                      Boolean         extendedOnly = false ) const;

/*------------------------------ Related Types -------------------------------*/
enum Alignment {
  topRight,
  bottomLeft,
  centered };
enum HomePosition {
  homeTopRight,
  homeBottomLeft };
enum Scale {
  scale1,
  scale2 };

/*----------------------------- Style Functions ------------------------------*/
Alignment
  alignment ( ) const;

HomePosition
  homePosition ( ) const;

Scale
  primaryScale ( ) const;

Boolean
  isVertical           ( ) const,
  isRibbonStripEnabled ( ) const,
  isSnapToTickEnabled  ( ) const;
Boolean
  isDrawItemEnabled    ( ) const,
  isPMCompatible       ( ) const;

virtual IProgressIndicator
 &setHomePosition    ( HomePosition home = homeBottomLeft ),
 &setPrimaryScale    ( Scale        primaryScale = scale1 ),
 &enableSnapToTick   ( Boolean      enableSnapToTick = true ),
 &disableSnapToTick  ( ),
 &enableRibbonStrip  ( Boolean      enableRibbonStrip = true ),
 &disableRibbonStrip ( );
virtual IProgressIndicator
 &enableDrawItem     ( Boolean      enableDrawItem = true ),
 &disableDrawItem    ( );

/*----------------------------- Tick Operations ------------------------------*/
IString
  tickText ( unsigned long tickNumber ) const;

IPoint
  tickPosition ( unsigned long tickNumber ) const;

unsigned long
  tickLength    ( unsigned long tickNumber ) const,
  tickSpacing   ( Scale         scale ) const,
  numberOfTicks ( Scale         scale ) const;

virtual IProgressIndicator
 &setTickLength ( unsigned long      tickNumber,
                  unsigned long      length ),
 &setTickLength ( unsigned long      length ),
 &setTicks      ( unsigned long      scale1NumberOfTicks,
                  unsigned long      scale2NumberOfTicks,
                  unsigned long      scale1TickSpacing = 0,
                  unsigned long      scale2TickSpacing = 0 ),
 &setTicks      ( Scale              scale,
                  unsigned long      numberOfTicks,
                  unsigned long      tickSpacing = 0 ),
 &setTickText   ( unsigned long      tickNumber,
                  const char*        text ),
 &setTickText   ( unsigned long      tickNumber,
                  const IResourceId& text );

/*----------------------------- Shaft Operations -----------------------------*/
virtual IPoint
  shaftPosition ( ) const;

virtual ISize
  shaftSize ( ) const;

virtual IProgressIndicator
 &setShaftPosition ( const IPoint& position );
virtual IProgressIndicator
 &setShaftBreadth  ( unsigned long breadth );

/*------------------------------ Arm Operations ------------------------------*/
virtual unsigned long
  armRange       ( ) const,
  armPixelOffset ( ) const,
  armTickOffset  ( ) const;

virtual IProgressIndicator
 &moveArmToTick  ( unsigned long tickNumber ),
 &moveArmToPixel ( unsigned long armOffset );

/*---------------------------- Color Functions -------------------------------*/
virtual IColor
  backgroundColor ( ) const;


/*-------------------------------- Overrides ---------------------------------*/

/*----------------------- Notification Event Descriptions --------------------*/
static INotificationId const
  IC_IMPORTU scaleId,
  IC_IMPORTU armChangeId;

/*----------------------- Observer Notification ------------------------------*/
virtual IProgressIndicator
 &enableNotification ( Boolean enable=true );


protected:
/*------------------------------ Implementation ------------------------------*/
virtual ISize
  calcMinimumSize ( ) const;

void
  initialize ( unsigned long     windowId,
               unsigned long     parent,
               unsigned long     owner,
               unsigned long     style,
               const IRectangle& initial,
               void*             sliderData );


/*-------------------------- Protected Constructors --------------------------*/
  IProgressIndicator ( );


/*-------------------------- Event Handling Implementation -------------------*/


private:
/*------------------------------ Hidden Members ------------------------------*/
  IProgressIndicator ( const IProgressIndicator& progIndicator );
IProgressIndicator
 &operator=          ( const IProgressIndicator& progIndicator );

/*--------------------------------- Private ----------------------------------*/
char*
  getTickText ( unsigned long tickNumber,
                char*         buffer = 0,
                unsigned long bufferLength = 0 ) const;
unsigned long
  tickTextLength ( unsigned long tickNumber ) const;

IProgressIndicatorData
 *fProgressIndicatorData;

static Style
  currentDefaultStyle;

friend class INativeSliderHandler;
friend long  __stdcall
   isliderTrackbarWinProc( void*         hwnd,
                           unsigned int  msg,
                           unsigned int  mp1,
                           long          mp2 );

/*--------------------------Obsolete Data and Functions ----------------------*/
#if (IC_OBSOLETE <= IC_OBSOLETE_2)
public:
static INotificationId const
  IC_IMPORTU armTickOffsetId,
  IC_IMPORTU armPixelOffsetId;
#endif
};  // IProgressIndicator

INESTEDBITFLAGCLASSFUNCS(Style, IProgressIndicator);


class ISlider : public IProgressIndicator  {
typedef IProgressIndicator
  Inherited;

public:
class Style;

/*------------------------------ Constructors --------------------------------*/
  ISlider  ( unsigned long         windowId,
             IWindow*              parent,
             IWindow*              owner,
             const IRectangle&     initial,
             unsigned long         numberOfTicks,
             unsigned long         tickSpacing = 0,
             const Style&          style = defaultStyle() );
  ISlider  ( unsigned long         windowId,
             IWindow*              parent,
             IWindow*              owner,
             const IRectangle&     initial,
             unsigned long         scale1NumberOfTicks,
             unsigned long         scale1TickSpacing,
             unsigned long         scale2NumberOfTicks,
             unsigned long         scale2TickSpacing = 0,
             const Style&          style = defaultStyle() );
  ISlider  ( unsigned long         windowId,
             IWindow*              parent );
  ISlider  ( const IWindowHandle&  handle );

virtual
  ~ISlider ( );

/*---------------------------------- Styles ----------------------------------*/
INESTEDBITFLAGCLASSDEF3(Style, ISlider, IWindow, IControl, IProgressIndicator);

static const Style
  IC_IMPORTU classDefaultStyle,
  IC_IMPORTU buttonsTop,
  IC_IMPORTU buttonsBottom,
  IC_IMPORTU buttonsLeft,
  IC_IMPORTU buttonsRight;

/*----------------------------- Style Members --------------------------------*/
static Style
  defaultStyle      ( );

static void
  setDefaultStyle   ( const Style&    style );

virtual unsigned long
  convertToGUIStyle ( const IBitFlag& style,
                      Boolean         extendedOnly = false ) const;

enum ButtonsPosition {
  top,
  bottom,
  left,
  right,
  none
};

ButtonsPosition
  buttonsPosition ( ) const;

/*---------------------------- Detent Operations -----------------------------*/
virtual unsigned long
  detentPosition ( unsigned long detentId ) const,  // in pixels
  addDetent      ( unsigned long offset );

virtual ISlider
 &removeDetent ( unsigned long detentId );

/*------------------------------ Arm Operations ------------------------------*/
ISize
  armSize   ( ) const;

virtual ISlider
 &setArmSize ( const ISize&  sliderArm );

/*-------------------------------- Attributes --------------------------------*/
virtual Boolean
  hasFocus ( ) const;

/*----------------------- Notification Event Descriptions --------------------*/
static INotificationId const
  IC_IMPORTU armTrackId;


private:
/*------------------------------ Hidden Members ------------------------------*/
  ISlider   ( const ISlider& slider );
ISlider
 &operator= ( const ISlider& slider );

/*--------------------------------- Private ----------------------------------*/
ISliderData
 *fSliderData;

static Style
  currentDefaultStyle;

friend IProgressIndicatorData;
}; // ISlider

INESTEDBITFLAGCLASSFUNCS(Style, ISlider);

#pragma pack()

  #include <islider.inl>

#endif /* _ISLIDER_ */
