#ifndef _ISLIDHDR_
  #define _ISLIDHDR_
/*******************************************************************************
* FILE NAME: islidhdr.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     ISliderDrawHandler                                                       *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ihandler.hpp>
#include <idievt.hpp>

#pragma pack(4)

class ISliderDrawHandler : public IHandler {
typedef IHandler
  Inherited;

public:
/*-------------------------- Constructors ------------------------------------*/
  ISliderDrawHandler   ( );

virtual
 ~ISliderDrawHandler   ( );


protected:
/*--------------------------- Command Dispatching ----------------------------*/
virtual Boolean
  dispatchHandlerEvent ( IEvent& event );

/*------------------------- Event Handling Functions -------------------------*/
virtual Boolean
  drawShaft            ( IDrawItemEvent& event ),
  drawRibbonStrip      ( IDrawItemEvent& event ),
  drawArm              ( IDrawItemEvent& event ),
  drawBackground       ( IDrawItemEvent& event );
};  // ISliderDrawHandler


#pragma pack()

#endif /* _ISLIDHDR_ */
