/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _ISM_H
#define _ISM_H

#include <iasm.h>
#include <iicsm.h>
#include <iivsm.h>
#include <iismavl.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class Key, class ElementOps>
class IGSortedMap;

template <class Element, class Key, class ElementOps>
class IGSortedMapCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef  IGSortedMap
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGSortedMapCursor
                            (IGSortedMap
                              <
                               Element, Key, ElementOps> const&);

  IGSortedMapCursor <Element, Key, ElementOps>&
           operator=        (IGSortedMapCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGSortedMapCursor
                            (ICursorImpl*);

private:


};

template <class Element, class Key, class ElementOps>
class IGSortedMap :
  public IASortedMap <Element, Key> {
protected:

  typedef  IGSortedMap <Element, Key, ElementOps> Self;

  typedef  ISortedMapAsAvlTreeImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSortedMapImpl
            <PureImplementation> Implementation;
#endif

#define IGSortedMapTypedef(Element, Key, ElementOps)\
  typedef  ISortedMapAsAvlTreeOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGSortedMapTypedef (Element, Key, ElementOps);

public:

  typedef  IGSortedMapCursor
            <Element, Key, ElementOps> Cursor;


           IGSortedMap
                            (INumber = 100);

           IGSortedMap
                            (IGSortedMap
                              <
                               Element, Key, ElementOps> const&);

  IGSortedMap <Element, Key, ElementOps>&
           operator=        (IGSortedMap
                              <
                               Element, Key, ElementOps> const&);


protected:

           IGSortedMap
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGSortedMap
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGSortedMapCursor
            <Element, Key, ElementOps>;



};

template <class Element, class Key>
class ISortedMap :
  public IGSortedMap
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IGSortedMap
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef  ISortedMap <Element, Key> Self;

#define ISortedMapTypedef(Element, Key)\
  typedef  ISortedMapAsAvlTreeOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           ISortedMap
                            (INumber = 100);


protected:

           ISortedMap
                              (PureImplementation&);

private:


};

template <class Element, class Key, class ElementOps>
class IVGSortedMap :
  public IGSortedMap
          <Element, Key, ElementOps > {

  typedef  IVGSortedMap
            <Element, Key, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVSortedMapImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSortedMapImpl
            <IVSortedMapImpl
              <PureImplementation> > Implementation;
#endif

#define IVGSortedMapTypedef(Element, Key, ElementOps)\
  typedef  ISortedMapAsAvlTreeOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGSortedMapTypedef (Element, Key, ElementOps);

public:

           IVGSortedMap
                            (INumber = 100);


protected:

           IVGSortedMap
                              (PureImplementation&);

private:


};

template <class Element, class Key>
class IVSortedMap :
  public IVGSortedMap
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IVGSortedMap
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef  IVSortedMap <Element, Key> Self;

#define IVSortedMapTypedef(Element, Key)\
  typedef  IVSortedMapAsAvlTreeOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IVSortedMap
                            (INumber = 100);


protected:

           IVSortedMap
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <ism.inl>

#pragma info (restore)
#pragma pack ()

#endif
