/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGSortedMapCursor
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGSortedMapCursor <Element, Key, ElementOps>::
IGSortedMapCursor
  (IGSortedMap
    <Element, Key, ElementOps> const& collection)
: IOrderedCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class Key, class ElementOps>
inline IGSortedMapCursor <Element, Key, ElementOps>&
IGSortedMapCursor <Element, Key, ElementOps>::
operator=
  (IGSortedMapCursor
    <Element, Key, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGSortedMapCursor <Element, Key, ElementOps>::
IGSortedMapCursor (ICursorImpl* impl)
: IOrderedCursor <Element> (impl)
{
}

// ---
// IGSortedMap
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGSortedMap <Element, Key, ElementOps>::
IGSortedMap (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class Key, class ElementOps>
inline
IGSortedMap <Element, Key, ElementOps>::
IGSortedMap
  (IGSortedMap
    <Element, Key, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class Key, class ElementOps>
inline IGSortedMap <Element, Key, ElementOps>&
IGSortedMap <Element, Key, ElementOps>::
operator= (IGSortedMap
            <Element, Key, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGSortedMap <Element, Key, ElementOps>::
IGSortedMap (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class Key, class ElementOps>
inline IGSortedMap
 <Element, Key, ElementOps>::Implementation&
IGSortedMap <Element, Key, ElementOps>::
ImplOf (IGSortedMap
         <Element, Key, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// ISortedMap
// ---

// public members

template <class Element, class Key>
inline
ISortedMap <Element, Key>::
ISortedMap (INumber numberOfElements)
: IGSortedMap
   <Element, Key, IEKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
ISortedMap <Element, Key>::
ISortedMap (PureImplementation& impl)
: IGSortedMap
   <Element, Key, IEKCOps <Element, Key> > (impl)
{
}

// ---
// IVGSortedMap
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IVGSortedMap <Element, Key, ElementOps>::
IVGSortedMap (INumber numberOfElements)
: IGSortedMap
    <Element, Key, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IVGSortedMap <Element, Key, ElementOps>::
IVGSortedMap (PureImplementation& impl)
: IGSortedMap
    <Element, Key, ElementOps> (impl)
{
}

// ---
// IVSortedMap
// ---

// public members

template <class Element, class Key>
inline
IVSortedMap <Element, Key>::
IVSortedMap (INumber numberOfElements)
: IVGSortedMap
   <Element, Key, IEKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IVSortedMap <Element, Key>::
IVSortedMap (PureImplementation& impl)
: IVGSortedMap
   <Element, Key, IEKCOps <Element, Key> > (impl)
{
}
