/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGSortedMapAsAvlTreeCursor
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGSortedMapAsAvlTreeCursor <Element, Key, ElementOps>::
IGSortedMapAsAvlTreeCursor
  (IGSortedMapAsAvlTree
    <Element, Key, ElementOps> const& collection)
: IOrderedCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class Key, class ElementOps>
inline IGSortedMapAsAvlTreeCursor <Element, Key, ElementOps>&
IGSortedMapAsAvlTreeCursor <Element, Key, ElementOps>::
operator=
  (IGSortedMapAsAvlTreeCursor
    <Element, Key, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGSortedMapAsAvlTreeCursor <Element, Key, ElementOps>::
IGSortedMapAsAvlTreeCursor (ICursorImpl* impl)
: IOrderedCursor <Element> (impl)
{
}

// ---
// IGSortedMapAsAvlTree
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGSortedMapAsAvlTree <Element, Key, ElementOps>::
IGSortedMapAsAvlTree (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class Key, class ElementOps>
inline
IGSortedMapAsAvlTree <Element, Key, ElementOps>::
IGSortedMapAsAvlTree
  (IGSortedMapAsAvlTree
    <Element, Key, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class Key, class ElementOps>
inline IGSortedMapAsAvlTree <Element, Key, ElementOps>&
IGSortedMapAsAvlTree <Element, Key, ElementOps>::
operator= (IGSortedMapAsAvlTree
            <Element, Key, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGSortedMapAsAvlTree <Element, Key, ElementOps>::
IGSortedMapAsAvlTree (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class Key, class ElementOps>
inline IGSortedMapAsAvlTree
 <Element, Key, ElementOps>::Implementation&
IGSortedMapAsAvlTree <Element, Key, ElementOps>::
ImplOf (IGSortedMapAsAvlTree
         <Element, Key, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// ISortedMapAsAvlTree
// ---

// public members

template <class Element, class Key>
inline
ISortedMapAsAvlTree <Element, Key>::
ISortedMapAsAvlTree (INumber numberOfElements)
: IGSortedMapAsAvlTree
   <Element, Key, IEKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
ISortedMapAsAvlTree <Element, Key>::
ISortedMapAsAvlTree (PureImplementation& impl)
: IGSortedMapAsAvlTree
   <Element, Key, IEKCOps <Element, Key> > (impl)
{
}

// ---
// IVGSortedMapAsAvlTree
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IVGSortedMapAsAvlTree <Element, Key, ElementOps>::
IVGSortedMapAsAvlTree (INumber numberOfElements)
: IGSortedMapAsAvlTree
    <Element, Key, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IVGSortedMapAsAvlTree <Element, Key, ElementOps>::
IVGSortedMapAsAvlTree (PureImplementation& impl)
: IGSortedMapAsAvlTree
    <Element, Key, ElementOps> (impl)
{
}

// ---
// IVSortedMapAsAvlTree
// ---

// public members

template <class Element, class Key>
inline
IVSortedMapAsAvlTree <Element, Key>::
IVSortedMapAsAvlTree (INumber numberOfElements)
: IVGSortedMapAsAvlTree
   <Element, Key, IEKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IVSortedMapAsAvlTree <Element, Key>::
IVSortedMapAsAvlTree (PureImplementation& impl)
: IVGSortedMapAsAvlTree
   <Element, Key, IEKCOps <Element, Key> > (impl)
{
}
